*Genera y consolida antropometrias.
*Elaborado: Rita Ricaldi; 10/10/07;5/12/07.

*----------------------------------------------------------------------------------------------------*.
*                                       CONFIGURA PATH DE DATOS               *.
*----------------------------------------------------------------------------------------------------*.
FILE HANDLE PROGRAMAS   /NAME='C:\06 CENAN\_CENAN\00 MONIN\01 Programas\99 zAntroWHO2006'.
FILE HANDLE DATOS     /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_consolidado1997-2006'.
FILE HANDLE DATOS01 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\01 MONIN1996\98 BDatosAnalisisMONIN-1996'.
FILE HANDLE DATOS02 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\02 MONIN1997\98 BDatosAnalisisMONIN-1997'.
FILE HANDLE DATOS03 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\03 MONIN1998\98 BDatosAnalisisMONIN-1998'.
FILE HANDLE DATOS04 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\04 MONIN1999\98 BDatosAnalisisMONIN-1999'.
FILE HANDLE DATOS05 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\05 MONIN2000\98 BDatosAnalisisMONIN-2000'.
FILE HANDLE DATOS06 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\06 MONIN2001\98 BDatosAnalisisMONIN-2001'.
FILE HANDLE DATOS07 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\07 MONIN2002\98 BDatosAnalisisMONIN-2002'.
FILE HANDLE DATOS08 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\08 MONIN2003\98 BDatosAnalisisMONIN-2003'.
FILE HANDLE DATOS09 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\09 MONIN2004\98 BDatosAnalisisMONIN-2004'.
FILE HANDLE DATOS10 /NAME='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\10 MONIN2006\98 BDatosAnalisisMONIN-2006'.

DEFINE !p()
'DBQ=C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\'
!ENDDEFINE.

*----------------------------------------------------------------------------------------------------*.
*          CONSOLIDAR Antropometrias de Ninos                                *.
*----------------------------------------------------------------------------------------------------*.
GET
  FILE='DATOS01\Nino.sav'
/Keep id_enc nficha idNino FecEnc FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS02\Nino.sav'/Keep id_enc nficha idNino  FecEnc FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS03\Nino.sav'/Keep id_enc nficha idNino  FecEnc FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS04\Nino.sav'/Keep id_enc nficha idNino  FecEnc FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS05\Nino.sav'/Keep id_enc nficha idNino  FecEnc FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS06\Nino.sav'/Keep id_enc nficha idNino  FecEnc FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS07\Nino.sav'/Keep id_enc nficha idNino FecEnc  FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS08\Nino.sav'/Keep id_enc nficha idNino FecEnc  FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS09\Nino.sav'/Keep id_enc nficha idNino FecEnc  FecNac Sexo Peso Talla Metodo id.
ADD FILES /FILE=* /FILE='DATOS10\Nino.sav'/Keep id_enc nficha idNino FecEnc  FecNac Sexo Peso Talla Metodo id.
execute.

*>> Genera ID para su uso con EpiNut de EpiInfo.
COMPUTE  id=$casenum.
VARI LABEL  id 'Id correlativo (unico de 1996 al 2006)'.
FORMAT id (f11.0).
EXECUTE.
SAVE OUTFILE='DATOS\zAntroNinos.sav'
/COMPRESSED.

*----------------------------------------------------------------------------------------------------*.
*           Agregar zScore segun tablas de referencia CDC 1978            *.
*----------------------------------------------------------------------------------------------------*.
compute metodo1=-1.
if(metodo=1)metodo1=0.
if(metodo=2)metodo1=1.
recode metodo1(-1=sysmis).
execute.
Vari label metodo1 'Metodo codificado segun EpiNut (0=echado,1=de pie)'.
valu label metodo1 0'Echado' 1'De pie'.

*>> Exporta a Access para el modulo EpiNut de EpiInfo 2000.
SAVE TRANSLATE
 /CONNECT=
'DSN=MS Access Database;'+!p+
'zAntroNinos.mdb;'
/TABLE='zAntro'
/TYPE=ODBC .
*>>>>>>>>>>>> procesar con EpiNut las antropometrias>>>>>.

*>>importa de access los resultados de EpiNut.

GET DATA /TYPE=ODBC /CONNECT=
 'DSN=MS Access Database;' +!p+
 'DriverId=25;FIL=MS Access;MaxBufferSize=2048;PageTimeout=5;'
 /SQL =
 'SELECT  fldIdNo,  fldCurrentDate,  fldFirstName,  fldName,  fldSex,  fldAge,  fldBirthDate,  fldEdema,  fldNotes,  fldCm, '
  ' fldInch,  fldRecumbent,  fldKilos,  fldLbs,  fldOzs,  fldCDCHAC,  fldCDCWHC,  fldCDCWAC,  fldCDCHAZ,  fldCDCWAZ,  '
  'fldCDCWHZ,  fldCDCFlag,  fldCDCHAFlag,  fldCDCWAFlag,  fldCDCWHFlag,  fldCDCBMIFlag,  fldWHOHAC,  fldWHOWHC,  fldWHOWAC, '
  ' fldWHOHAZ,  fldWHOWAZ,  fldWHOWHZ,  fldWHOHAPM,  fldWHOWHPM,  fldWHOWAPM,  fldWHOFlag,  fldcmMUAC,  fldinMUAC,  '
  'fldMUACAgeZ,  fldMUACHeightZ,  fldcmHCircum,  fldinHCircum,  fldHCircumC,  fldHCircumZ,  fldBMI,  fldBMIC,  fldBMIZ FROM '
  ' nutzAntroCDC'
 /ASSUMEDSTRWIDTH=255
 .
CACHE.
EXECUTE.

*>>renombra las variables, declara los flags, declara los missing.
Rename Vari (fldIdNo=Id) (fldWHOHAZ=zHA78) ( fldWHOWAZ=zWA78) ( fldWHOWHZ=zWH78) (fldWHOFlag=flag78).
VARI LABEL  id 'Id correlativo (unico de 1996 al 2006)'.
VARI LABEL  zha78 'z score T/E 1978'.
VARI LABEL zwa78 'z score P/E 1978'. 
VARI LABEL zwh78 'z score P/T 1978'. 
VARI LABEL flag78 'Flags 1978'.
Value label flag78 0 'Ningun indice con flag' 1 'Flag HAZ' 2 'Flag WHZ'	3 'Flag HAZ WHZ' 4 'Flag WAZ' 5 'Flag HAZ WAZ'	 6 'Flag WHZ WAZ'	7 'Flag WHZ WAZ HAZ'.	
If(flag78=1) zha78=999.99.
If(flag78=3) zha78=999.99.
If(flag78=5) zha78=999.99.
If(flag78=7) zha78=999.99.
execute.
If(flag78=4) zwa78=999.99.
If(flag78=5) zwa78=999.99.
If(flag78=6) zwa78=999.99.
If(flag78=7) zwa78=999.99.
execute.
If(flag78=2) zwh78=999.99.
If(flag78=3) zwh78=999.99.
If(flag78=6) zwh78=999.99.
If(flag78=7) zwh78=999.99.
MISSING VALUES zha78,zwa78,zwh78 (999.99).
execute.

**Declaro flags para c/u de los zscores*.
if (zwh78 < -4 or zwh78 >6) wh78flag =1.
if (zha78 < -6 or zha78 >6 ) ha78flag =1.
if (zwa78 < -6 or zwa78 >6 ) wa78flag =1.
Vari label wh78flag 'Peso/Talla fuera de rango[zwhz < -4 or zwhz >6]'.
Vari label ha78flag 'Talla/Edad fuera de rango[zhaz < -6 or zhaz >6]'.
Vari label wa78flag 'Peso/Edad fuera de rango[zwaz < -6 or zwaz >6]'.
execute.
SORT CASES BY
  Id (A) .

SAVE OUTFILE='DATOS\zAntroNinos1978.sav'
/KEEP Id  zha78 zwa78 zwh78 flag78
 /COMPRESSED.

*>>Abre el zAntroNinos y en base al "id" match con resultados del EpiNut.
GET
  FILE='DATOS\zAntroNinos.sav'.
SORT CASES BY
  id (A) .
MATCH FILES /FILE=*
 /TABLE='DATOS\zAntroNinos1978.sav'
 /BY id.
EXECUTE.
SAVE OUTFILE='DATOS\zAntroNinos.sav'
 /COMPRESSED.

*----------------------------------------------------------------------------------------------------*.
*          Agregar zScore segun tablas de referencia OMS 2006            *.
*----------------------------------------------------------------------------------------------------*.
*>>Ejecuta zAntroWHO.sps.
INSERT FILE='PROGRAMAS\zAntroWHO2006.sps'.

SAVE OUTFILE ='DATOS\zAntroNinos.sav'
/KEEP id_enc nficha idNino FecEnc FecNac  Sexo Metodo Talla Peso
 id zha78 zwa78 zwh78 flag78
wh78flag ha78flag wa78flag
zhaz zwaz zwhz
whzflag hazflag wazflag
whznoage flag4 flag5 flag6  flag7 flagnew .
execute.

*----------------------------------------------------------------------------------------------------*.
*       Agregar a cada tabla analitica ninos los zScore                         *.
*----------------------------------------------------------------------------------------------------*.
*>Tabla analiticanino 1996.
GET
  FILE='DATOS01\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS01\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 1997.
GET
  FILE='DATOS02\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS02\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 1998.
GET
  FILE='DATOS03\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS03\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 1999.
GET
  FILE='DATOS04\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS04\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 2000.
GET
  FILE='DATOS05\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS05\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 2001.
GET
  FILE='DATOS06\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS06\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 2002.
GET
  FILE='DATOS07\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS07\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 2003.
GET
  FILE='DATOS08\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS08\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 2004.
GET
  FILE='DATOS09\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS09\Nino.sav'
 /COMPRESSED.

*>Tabla analiticanino 2006.
GET
  FILE='DATOS10\Nino.sav'.
SORT CASES BY
  id_enc (A) nficha (A) idNino (A) .
MATCH FILES /FILE=*
 /TABLE='C:\06 CENAN\_CENAN\00 MONIN\02 MONIN 1997-2006\11 MONIN_Consolidado1997-2006\zAntroNinos.sav'
 /RENAME (FecEnc FecNac Metodo Peso Sexo Talla = d0 d1 d2 d3 d4 d5)
 /BY id_enc nficha idNino
 /DROP= d0 d1 d2 d3 d4 d5.
EXECUTE.
SAVE OUTFILE='DATOS10\Nino.sav'
 /COMPRESSED.













