********************************************************************************************************.
*                             Elaborado: Rita Ricaldi/Luis Cordero                                     *.
*                             Fecha: 05 Julio 2008                                                     *.
*                             Actualizado 27 Julio 2008,12 Agosto 2008,03 Setiembre 2008, 23 Noviembre *.
********************************************************************************************************.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*	S I N T A X I S   E L A B O R A D A   P A R A    C E N A N,  P A R A   E L   A N A L I S I S   D E L                            *.
*																			     *.
*   M O D U L O    D E   A N T R O PO M E T R I A    D E    E N A H O    I V    T R I M E S T R E     2 0 0 7                          *. 
*																			     *.
*                    Incluye la base de datos analiticas y los tabulados									     *.
*															                                *.
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.


*------------------------------------------------------------------------------------------------------------------------------------------ *.
*                                            Configurar Paths.
*------------------------------------------------------------------------------------------------------------------------------------------ *.

FILE HANDLE DATOS /NAME='C:\06 CENAN\04 UINutricional\08 ENAHO\03 BDatosOriginalesENAHO'.
FILE HANDLE DATOS1 /NAME='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO'.

DEFINE !p()
'DBQ=C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\'
!ENDDEFINE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*	                    T A B L A S    D E    I N E I    E N A H O							                    *. 
*				Son las tablas bajadas de la Web											      *.
*//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

*--->>Juntamos las tablas del cap 200 400 100 Y SUMARIA DE ENAHO <<----- *.
*--------------------------------------------------------------------------------------------------------------------------- *.
*-------Cap200------------*.
GET FILE ='DATOS\Enaho01-2007-200.sav'.
SORT CASES BY CONGLOME VIVIENDA HOGAR CODPERSO (A).
SAVE OUTFILE='DATOS\tmpCap200.sav'
/keep
CONGLOME VIVIENDA HOGAR CODPERSO
UBIGEO DOMINIO ESTRATO 
P203 P203A P203B
P204 P205 P206 P207 P208A P208B P208A1 P208A2
P209 P210 P211 P212 P213 P214 P215 P216 P217
T211.
execute.

*-------Cap400------------*.
GET FILE ='DATOS\Enaho01A-2007-400.sav'.
SORT CASES BY CONGLOME VIVIENDA HOGAR CODPERSO.
SAVE OUTFILE='DATOS\tmpCap400.sav'
/keep
CONGLOME VIVIENDA HOGAR CODPERSO
FACTOR
P203 P301A
P400A1 P400A2 P400A3
P4191 P4192 P4193 P4194 P4195 P4196 P4197 P4198 P4199
P4131 P4131A P4132 P4132A P4133 P4133A P4134 P4134A P4135 P4135A.

*-------Juntamos Cap200 y Cap400------------*.
GET FILE ='DATOS\tmpCap200.sav'.
SORT CASES BY CONGLOME VIVIENDA HOGAR CODPERSO (A).

MATCH FILES /FILE=*
/TABLE='DATOS\tmpCap400.sav'
/BY CONGLOME VIVIENDA HOGAR CODPERSO
/keep
CONGLOME VIVIENDA HOGAR CODPERSO 
UBIGEO DOMINIO ESTRATO 
P203 P203A P203B
P204 P205 P206 P207 P208A P208B P208A1 P208A2
P209 P210 P211 P212 P213 P214 P215 P216 P217 T211
FACTOR
P203 P301A
P400A1 P400A2 P400A3
P4191 P4192 P4193 P4194 P4195 P4196 P4197 P4198 P4199
P4131 P4131A P4132 P4132A P4133 P4133A P4134 P4134A P4135 P4135A.
execute.
SAVE OUTFILE='DATOS1\MiembrosENAHOIV2007.sav'.

*-----------Cap100-------------------*.
GET FILE ='DATOS\Enaho01-2007-100.sav'.
SORT CASES BY CONGLOME VIVIENDA HOGAR.
RENAME VARI (FACTOR=FAC_HOG).
EXECUTE.
SAVE OUTFILE='DATOS\tmpCap100.sav'
/keep
CONGLOME VIVIENDA HOGAR
FAC_HOG
P101 P102 P103 P103A P104 P104A P110 P111 P1121 P1122 P1123 P1124 P1125 P1126 P1127 P112A P1131 P1132 P1133 P1134 P1135 P1136 P1137 P1138
P701
NBI1 NBI2 NBI3 NBI4 NBI5.
execute.

*-------Juntamos Cap100 con Cap200 y Cap400-------------------*.
GET FILE ='DATOS1\MiembrosENAHOIV2007.sav'.
SORT CASES BY CONGLOME VIVIENDA HOGAR (A).

MATCH FILES /FILE=*
/TABLE='DATOS\tmpCap100.sav'
/BY CONGLOME VIVIENDA HOGAR 
/keep
CONGLOME VIVIENDA HOGAR CODPERSO 
UBIGEO DOMINIO ESTRATO 
P203 P203A P203B
P204 P205 P206 P207 P208A P208B P208A1 P208A2
P209 P210 P211 P212 P213 P214 P215 P216 P217 T211
FACTOR
P203 P301A
P400A1 P400A2 P400A3
P4191 P4192 P4193 P4194 P4195 P4196 P4197 P4198 P4199
P4131 P4131A P4132 P4132A P4133 P4133A P4134 P4134A P4135 P4135A
FAC_HOG
P101 P102 P103 P103A P104 P104A P110 P111 P1121 P1122 P1123 P1124 P1125 P1126 P1127 P112A P1131 P1132 P1133 P1134 P1135 P1136 P1137 P1138
P701
NBI1 NBI2 NBI3 NBI4 NBI5.
execute.

SAVE OUTFILE='DATOS1\MiembrosENAHOIV2007.sav'.

*----------------------------------------------------------------------------------------------------*.
*           Extraemos los quintiles de pobreza del archivo SUMARIA-2007-IV-Trimestre.sav             *.
*----------------------------------------------------------------------------------------------------*.
GET FILE='DATOS1\MiembrosENAHOIV2007.sav'.
SORT CASES BY
CONGLOME VIVIENDA HOGAR (A) .
SAVE OUTFILE='DATOS1\MiembrosENAHOIV2007.sav'.

GET FILE='DATOS\SUMARIA-2007-IV-Trimestre.sav'.
SORT CASES BY
CONGLOME VIVIENDA HOGAR (A) .
SAVE OUTFILE='DATOS1\tmpSUMARIA-2007-IV-Trimestre.sav'.

GET FILE='DATOS1\MiembrosENAHOIV2007.sav'.

MATCH FILES /FILE=*
/TABLE='DATOS1\tmpSUMARIA-2007-IV-Trimestre.sav'
/BY CONGLOME VIVIENDA HOGAR
/keep
CONGLOME VIVIENDA HOGAR CODPERSO 
UBIGEO DOMINIO ESTRATO 
P203 P203A P203B
P204 P205 P206 P207 P208A P208B P208A1 P208A2
P209 P210 P211 P212 P213 P214 P215 P216 P217 T211
FACTOR
P203 P301A
P400A1 P400A2 P400A3
P4191 P4192 P4193 P4194 P4195 P4196 P4197 P4198 P4199
P4131 P4131A P4132 P4132A P4133 P4133A P4134 P4134A P4135 P4135A
FAC_HOG
P101 P102 P103 P103A P104 P104A P110 P111 P1121 P1122 P1123 P1124 P1125 P1126 P1127 P112A P1131 P1132 P1133 P1134 P1135 P1136 P1137 P1138
P701
NBI1 NBI2 NBI3 NBI4 NBI5
NTI001 MIEPERHO TOTMIEHO PERCEPHO 
INGMO1HD INGMO2HD INGHOG1D INGHOG2D GASHOG1D GASHOG2D linpe07 linea07 POBREZA Ngasper.
EXECUTE.

SAVE OUTFILE='DATOS1\MiembrosENAHOIV2007.sav'.

*******************************************************************************************************************.
*  SE EXTRAEN VARIABLES RELACIONADAS AL HOGAR DE Enaho01-2007-200.sav edad y sexo del jefe del hogar 		     *.	
*  y del Enaho01A-2007-300.sav nivel de educacion e idioma del jefe del hogar					     *.
********************************************************************************************************************.
GET
  FILE='DATOS\Enaho01-2007-200.sav'.

SORT CASES BY
  CONGLOME (A) VIVIENDA (A) HOGAR (A) CODPERSO (A).

*>> Datos del jefe del hogar.
Compute jhEdad=0.
Compute jhSexo=0.
if (P203=1)jhEdad=P208A.
if (P203=1)jhSexo=P207.
execute.
vari label
jhEdad 'Edad [Jefe hogar]'
/jhSexo 'Sexo[Jefe hogar]'
.
Value label jhSexo 1'Masculino' 2'Femenino'.
execute.

AGGREGATE
  /OUTFILE='DATOS1\tmp200.sav'
  /BREAK=CONGLOME VIVIENDA HOGAR 
/jhEdad 'Edad [Jefe hogar]'  =sum(jhEdad)
/jhSexo 'Sexo[Jefe hogar]'	 =sum(jhSexo).
execute.

GET
  FILE='DATOS\Enaho01A-2007-300.sav'.

SORT CASES BY
  CONGLOME (A) VIVIENDA (A) HOGAR (A) CODPERSO (A).
Compute jhNivEd=0.
Compute jhIdiom=0.
execute.
If(P203=1)jhNivEd=P301A.
If(P203=1)jhIdiom=P300A.
execute.
vari label
jhNivEd 'Nivel de educacin [Jefe hogar]'
/jhIdiom 'Idioma[Jefe hogar]'
.
Value label jhNivEd 1'Sin nivel' 
2'Educacin inicial' 
3'Primaria incompleta' 
4'Primaria completa' 
5'Secundaria incompleta' 
6'Secundaria completa'
7'Sup no Univ Incompleta'
8'Sup no Univ Completa'
9'Sup Univ Incompleta'
10'Sup Univ Completa'
11'Post-Grado Universitario'
.
execute.

Value label jhIdiom 1'Quechua' 
2'Aymar' 
3'Otra lengua nativa' 
4'Castellano' 
5'Ingls' 
6'Portugues'
7'Otra lengua extranjera'
8'Es sordo mudo'.
execute.

AGGREGATE
  /OUTFILE='DATOS1\tmp300.sav'
  /BREAK=CONGLOME VIVIENDA HOGAR 
/jhNivEd 'Nivel de educacin [Jefe hogar]'=sum(jhNivEd)
/jhIdiom 'Idioma[Jefe hogar]'=sum(jhIdiom).
execute.

GET FILE='DATOS1\MiembrosENAHOIV2007.sav'.
SORT CASES BY
CONGLOME VIVIENDA HOGAR (A) .

MATCH FILES /FILE=*
/TABLE='DATOS1\tmp200.sav'
/BY CONGLOME VIVIENDA HOGAR
/keep
CONGLOME VIVIENDA HOGAR CODPERSO 
UBIGEO DOMINIO ESTRATO 
P203 P203A P203B
P204 P205 P206 P207 P208A P208B P208A1 P208A2
P209 P210 P211 P212 P213 P214 P215 P216 P217 T211
FACTOR
P203 P301A
P400A1 P400A2 P400A3
P4191 P4192 P4193 P4194 P4195 P4196 P4197 P4198 P4199
P4131 P4131A P4132 P4132A P4133 P4133A P4134 P4134A P4135 P4135A
FAC_HOG
P101 P102 P103 P103A P104 P104A P110 P111 P1121 P1122 P1123 P1124 P1125 P1126 P1127 P112A P1131 P1132 P1133 P1134 P1135 P1136 P1137 P1138
P701
NTI001 MIEPERHO TOTMIEHO PERCEPHO 
INGMO1HD INGMO2HD INGHOG1D INGHOG2D GASHOG1D GASHOG2D linpe07 linea07 POBREZA Ngasper
jhEdad jhSexo .
EXECUTE.

MATCH FILES /FILE=*
/TABLE='DATOS1\tmp300.sav'
/BY CONGLOME VIVIENDA HOGAR
/keep
CONGLOME VIVIENDA HOGAR CODPERSO 
UBIGEO DOMINIO ESTRATO 
P203 P203A P203B
P204 P205 P206 P207 P208A P208B P208A1 P208A2
P209 P210 P211 P212 P213 P214 P215 P216 P217 T211
FACTOR
P203 P301A
P400A1 P400A2 P400A3
P4191 P4192 P4193 P4194 P4195 P4196 P4197 P4198 P4199
P4131 P4131A P4132 P4132A P4133 P4133A P4134 P4134A P4135 P4135A
FAC_HOG
P101 P102 P103 P103A P104 P104A P110 P111 P1121 P1122 P1123 P1124 P1125 P1126 P1127 P112A P1131 P1132 P1133 P1134 P1135 P1136 P1137 P1138
P701
NTI001 MIEPERHO TOTMIEHO PERCEPHO 
INGMO1HD INGMO2HD INGHOG1D INGHOG2D GASHOG1D GASHOG2D linpe07 linea07 POBREZA Ngasper
jhEdad jhSexo 
jhNivEd jhIdiom .
EXECUTE.

SAVE OUTFILE='DATOS1\MiembrosENAHOIV2007.sav'.
********************************************************************************************************************.
*  La tabla MiembrosENAHOIV2007.sav contiene las variables demograficas y todos los miembros captados durante      *.
*  la encuesta realizada por INEI		     										     *.	
********************************************************************************************************************.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*																			     *. 	
*	 T A B L A S    D E    C E N A N - A N T R O P O M E T R I A     E N A H O						                   *. 
*																			     *.		
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

********************************************************************************************************************.
*	La siguiente lista de tablas fueron entregadas por INEI a CENAN, corresponden al modulo de antropometria     *.	
* Enaho - Cenan IV Trim Hogar.sav    *.
* Enaho - Cenan IV Trim personas.sav *.
* Cenan2007-Prendas IV Trim.sav      *.
* Cenan2007-Visitas IV Trim.sav      *.
********************************************************************************************************************.
GET
  FILE='DATOS\Enaho - Cenan IV Trim Hogar.sav'.

SORT CASES BY
  CONGLOME (A) VIVIENDA (A) HOGAR (A).

SAVE OUTFILE='DATOS\tmpHogares.sav'
/keep
AO MES CONGLOME VIVIENDA HOGAR
CCDD CCPP CCDI NOMBRECCPP 
UBIGEO DOMINIO ESTRATO
TIPOSELE NROVIV
ALTITUD
RESULTADO
FACTCENAN.

*-------->>Se agrega fecha de encuesta en la tabla de Hogares<<-------------- *.
GET
  FILE='DATOS\Cenan2007-Visitas IV Trim.sav'.
SORT CASES BY
  CONGLOME (A) VIVIENDA (A) HOGAR (A).
compute FecEnc=DATE.DMY(DIA_VISITA,MES_VISITA,ANIO_VISITA).	
execute.
Format FecEnc (EDATE10).
vari label FecEnc 'Fecha de Encuesta'.

AGGREGATE
  /OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\03 BDatosOriginalesENAHO\tmpVisitas.sav'
  /BREAK=CONGLOME VIVIENDA HOGAR
  /NVISITA_max = MAX(NVISITA) /FecEnc_max = MAX(FecEnc)
  /N_BREAK=N.

GET
  FILE='DATOS\tmpVisitas.sav'.
Rename vari (NVISITA_max FecEnc_max = NVISITA FecEnc).

SAVE OUTFILE='DATOS\tmpVisitas.sav'
/keep
CONGLOME VIVIENDA HOGAR 
NVISITA FecEnc.

*-------->>Se agrega fecha de encuesta en la tabla de personas<<-------------- *.
GET
  FILE='DATOS\Enaho - Cenan IV Trim personas.sav'.
SORT CASES BY
  CONGLOME (A) VIVIENDA (A) HOGAR (A).
SAVE OUTFILE='DATOS\tmpPersonas.sav'
/keep
 AO MES CONGLOME VIVIENDA HOGAR CODPERSO 
 UBIGEO DOMINIO ESTRATO RESULT RESULTADO CODINFOR 
 C101_NOM C101_SEXO C101_EDAD_ANIO C101_EDAD_MESES 
 C102A C102B C103 C104 C105_TOTAL C106 C107 C108 C109 C110 C111 
 C112A C112B C112C 
 C113 C114 C115 
 C116_11 C116_12 C116_13 C116_21 C116_22 C116_23 C116_31 C116_32 C116_33 C116_41 C116_42 C116_43 C116_51 C116_52 C116_53 C116_61 C116_62 C116_63 C116_71 C116_72 C116_73 
 NO_ENTRE_PERSONA FACPOTRI.
execute.

GET
  FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\03 BDatosOriginalesENAHO\tmpPersonas.sav'.

*Se extrae altitud y fecha de encuesta de la tabla hogar.
MATCH FILES /FILE=*
 /TABLE='DATOS\tmpHogares.sav'
 /BY CONGLOME VIVIENDA HOGAR
/keep
 AO MES CONGLOME VIVIENDA HOGAR CODPERSO 
 ALTITUD FACTCENAN
 UBIGEO DOMINIO ESTRATO RESULT RESULTADO CODINFOR 
 C101_NOM C101_SEXO C101_EDAD_ANIO C101_EDAD_MESES 
 C102A C102B C103 C104 C105_TOTAL C106 C107 C108 C109 C110 C111 
 C112A C112B C112C 
 C113 C114 C115 
 C116_11 C116_12 C116_13 C116_21 C116_22 C116_23 C116_31 C116_32 C116_33 C116_41 C116_42 C116_43 C116_51 C116_52 C116_53 C116_61 C116_62 C116_63 C116_71 C116_72 C116_73 
 NO_ENTRE_PERSONA FACPOTRI.
.
execute.

MATCH FILES /FILE=*
 /TABLE='DATOS\tmpVisitas.sav'
 /BY CONGLOME VIVIENDA HOGAR
/keep
 AO MES CONGLOME VIVIENDA HOGAR CODPERSO 
 ALTITUD FACTCENAN
 NVISITA FecEnc
 UBIGEO DOMINIO ESTRATO RESULT RESULTADO CODINFOR 
 C101_NOM C101_SEXO C101_EDAD_ANIO C101_EDAD_MESES 
 C102A C102B C103 C104 C105_TOTAL C106 C107 C108 C109 C110 C111 
 C112A C112B C112C 
 C113 C114 C115 
 C116_11 C116_12 C116_13 C116_21 C116_22 C116_23 C116_31 C116_32 C116_33 C116_41 C116_42 C116_43 C116_51 C116_52 C116_53 C116_61 C116_62 C116_63 C116_71 C116_72 C116_73 
 NO_ENTRE_PERSONA FACPOTRI.
.
execute.

*-------->>Genera fecha de nacimiento en formato dd.mm.aaaa<<-------------- *.
compute FecNac=DATE.DMY(C112A,C112B,C112C).	
execute.
Format FecNac (EDATE10).
vari label 
FecNac 'Fecha de nacimiento[registrado durante la antropometria]'.

Rename Variable (c101_sexo=sexo).
execute.
SORT CASES BY CONGLOME VIVIENDA HOGAR CODPERSO.

SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.

*-------Calculo de la variable edad ---------*.
compute EdadMes=DATEDIFF(FecEnc,FecNac,'MONTHS').
compute EdadAno=DATEDIFF(FecEnc,FecNac,'YEARS').
Compute EdaTri=trunc(EdadMes/3).
Compute EdaSem=trunc(EdadMes/3).
Compute EdaQui=trunc(EdadAno/5).
Compute EdaDec=trunc(EdadAno/10).
execute.
Compute EdaOPS=-1.
if(EdadAno=0) EdaOPS=1.
if(EdadAno>0 and EdadAno<=15) EdaOPS=2.
if(EdadAno>15 and EdadAno<=45) EdaOPS=3.
if(EdadAno>45 and EdadAno<=65) EdaOPS=4.
if(EdadAno>65 ) EdaOPS=5.
execute.
recode EdaOPS(-1=sysmis).
Value label EdaQui 0'<5' 1'5-9' 2'10-14' 3'15-19' 4'20-24' 
5'25-29' 6'30-34' 7'35-39' 8'40-44' 9'45-49' 10'50-54' 
11'55-59' 12'60-64' 13'65-69' 14'70-74' 15'75-79' 16'80-84'
17'85-89' 18'90-94' 19'>95'.

Recode EdaDec (7 thruw highest =7).
execute.
value label EdaDec 0'<10' 1'10-19' 2'20-29' 3'30-39' 4'40-49' 5'50-59' 6'60-69' 7'>70'.
compute EdaMEF1=-1.
if (EdadAno >=12 and EdadAno<=49 and sexo=2)EdaMEF1=EdaQui.
execute.
recode EdaMEF1(-1=sysmis).
execute.

compute EdaMEF2=-1.
if (EdadAno >=12 and EdadAno<=15 and sexo=2)EdaMEF2=1.
if (EdadAno >15 and EdadAno<=18 and sexo=2)EdaMEF2=2.
if (EdadAno >18 and EdadAno<=35 and sexo=2)EdaMEF2=3.
if (EdadAno >35 and EdadAno<=49 and sexo=2)EdaMEF2=4.
recode EdaMEF2(-1=sysmis).
execute.

Vari label 
EdadMes 'Edad(meses)'
/EdadAno 'Edad(aos)'
/EdaTri 'Edad (trimestre)'
/EdaSem 'Edad (semestre)'
/EdaQui 'Grupo etareo'
/EdaMEF1 'Edades quinquenales en MEF'
/EdaMEF2 'Edades agrupadas en MEF'
.
execute.

SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.

*-------->>Flags error<<-------------- *.
compute fFecNac=0.
If(FecNac>FecEnc)fFecNac=1.
if(Sysmis(FecNac)=1)fFecNac=2.
if (sysmis(FecEnc)=1)fFecNac=3.
execute.
Vari label fFecNac 'Error fecha de nacimiento'.
Valu label fFecNac
1'Fec Nacimiento > Fec Encuesta' 
2 'Fec Nac [Antropmetria] errado'
3 'Fec Enc [Antropometria] errado'
.
execute.
*------>>Genera fecha de nacimiento en formato dd.mm.aaaa del cap 400 bajado de la web<<------- *.
compute FecNac1=DATE.DMY(P400A1,P400A2,P400A3).	
Format FecNac1 (EDATE10).
execute.
vari label FecNac1 'Fecha de nacimiento [registrado en el cap 400]'.
execute.
if (FecNac<>FecNac1) fFecNac=5.
if (sysmis(FecNac1)=1) fFecNac=6.
if (Sysmis(FecNac)=1)fFecNac=2.
add valu label fFecNac
5 'FecNac de antropometria diferente a la Fec Nac del Cap 400'
6 'FecNac del cap 400 errado'.
execute.
*-------------->> Genera ID para el modulo Nutrition de EpiInfo v 3.4.1.
COMPUTE  id=$casenum.
VARI LABEL  id 'Id registro'.
FORMAT id (f11.0).
EXECUTE.
SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.

*--------------------------------------------------------------------------------------------------------------------------- *.

GET FILE='DATOS1\AntroENAHOIV2007.sav'.
*----------------------------------------------------------------------------------------------------*.
*           Agregar zScore segun tablas de referencia NCHS 1978            *.
*----------------------------------------------------------------------------------------------------*.
compute metodo1=-1.
if(C108=2)metodo1=0.
if(C108=1)metodo1=1.
recode metodo1(-1=sysmis).
execute.
Vari label metodo1 'Metodo codificado segun Nutrition (0=echado,1=de pie)'.
valu label metodo1 0'Echado' 1'De pie'.

*----------->> Exporta a Access para el modulo Nutrition de EpiInfo v 3.4.1.
SAVE TRANSLATE
 /CONNECT=
'DSN=MS Access Database;'+!p+
'zAntroNinosENAHO.mdb;'
/KEEP id CONGLOME VIVIENDA HOGAR CODPERSO metodo1 FecEnc FecNac sexo C104 C107
/TABLE='zAntro'
/TYPE=ODBC .

*>> procesar con Epi Nutrition las antropometrias >>>.

*>> importa de access los resultados de Nutrition.

GET DATA /TYPE=ODBC /CONNECT=
 'DSN=MS Access Database;' +!p+
'zAntroNinosENAHO.mdb;'
 'DriverId=25;FIL=MS Access;MaxBufferSize=2048;PageTimeout=5;'
 /SQL =
 'SELECT  fldIdNo,  fldCurrentDate,  fldFirstName,  fldName,  fldSex,  fldAge,  fldBirthDate,  fldEdema,  fldNotes,  fldCm, '
  ' fldInch,  fldRecumbent,  fldKilos,  fldLbs,  fldOzs,  fldCDCHAC,  fldCDCWHC,  fldCDCWAC,  fldCDCHAZ,  fldCDCWAZ,  '
  'fldCDCWHZ,  fldCDCFlag,  fldCDCHAFlag,  fldCDCWAFlag,  fldCDCWHFlag,  fldCDCBMIFlag,  fldWHOHAC,  fldWHOWHC,  fldWHOWAC, '
  ' fldWHOHAZ,  fldWHOWAZ,  fldWHOWHZ,  fldWHOHAPM,  fldWHOWHPM,  fldWHOWAPM,  fldWHOFlag,  fldcmMUAC,  fldinMUAC,  '
  'fldMUACAgeZ,  fldMUACHeightZ,  fldcmHCircum,  fldinHCircum,  fldHCircumC,  fldHCircumZ,  fldBMI,  fldBMIC,  fldBMIZ FROM '
  ' nutzAntro'
 /ASSUMEDSTRWIDTH=255
 .
CACHE.
EXECUTE.

*>>renombra las variables, declara los flags, declara los missing.
Rename Vari (fldIdNo=Id) (fldWHOHAZ=zHA78) ( fldWHOWAZ=zWA78) ( fldWHOWHZ=zWH78) (fldWHOFlag=flag78).
VARI LABEL id 'Id correlativo'.
VARI LABEL zha78 'z score Talla/Edad [NCHS 1978]'.
VARI LABEL zwa78 'z score Peso/Edad [NCHS 1978]'. 
VARI LABEL zwh78 'z score Peso/Talla [NCHS 1978]'. 
VARI LABEL flag78 'Flags 1978'.

Value label flag78 0 'Ningun indice con flag' 1 'Flag HAZ' 2 'Flag WHZ'	3 'Flag HAZ WHZ' 4 'Flag WAZ' 5 'Flag HAZ WAZ'	 6 'Flag WHZ WAZ'	7 'Flag WHZ WAZ HAZ'.	
If(flag78=1) zha78=999.99.
If(flag78=3) zha78=999.99.
If(flag78=5) zha78=999.99.
If(flag78=7) zha78=999.99.
execute.
If(flag78=4) zwa78=999.99.
If(flag78=5) zwa78=999.99.
If(flag78=6) zwa78=999.99.
If(flag78=7) zwa78=999.99.
execute.
If(flag78=2) zwh78=999.99.
If(flag78=3) zwh78=999.99.
If(flag78=6) zwh78=999.99.
If(flag78=7) zwh78=999.99.
if (zwh78 < -4 or zwh78 >6)zwh78 =999.99.
if (zha78 < -6 or zha78 >6 )zha78 =999.99.
if (zwa78 < -6 or zwa78 >6 )zwa78 =999.99.
MISSING VALUES zha78,zwa78,zwh78 (999.99).
execute.

**Declaro flags para c/u de los zscores*.
if (zwh78 < -4 or zwh78 >6) wh78flag =1.
if (zha78 < -6 or zha78 >6 ) ha78flag =1.
if (zwa78 < -6 or zwa78 >6 ) wa78flag =1.

Vari label wh78flag 'Peso/Talla fuera de rango[NCHS 1978:zwhz < -4 or zwhz >6]'.
Vari label ha78flag 'Talla/Edad fuera de rango[NCHS 1978:zhaz < -6 or zhaz >6]'.
Vari label wa78flag 'Peso/Edad fuera de rango[NCHS 1978:zwaz < -6 or zwaz >6]'.
execute.

SORT CASES BY
  Id (A) .

SAVE OUTFILE='DATOS1\zAntroNinos1.sav'
/KEEP Id zha78 zwa78 zwh78 wh78flag ha78flag wa78flag flag78
/COMPRESSED.


*******************************************************************************************.
*>>Abre el zAntroNinos y en base al "id" match con resultados del EpiNut.
GET
  FILE='DATOS1\zAntroNinos1.sav'.
SORT CASES BY
  id (A) .
SAVE OUTFILE='DATOS1\zAntroNinos1.sav'.

GET FILE='DATOS1\AntroENAHOIV2007.sav'.
SORT CASES BY
  id (A) .

MATCH FILES /FILE=*
 /TABLE='DATOS1\zAntroNinos1.sav'
 /BY id.
EXECUTE.

*Prevalencia de desnutricion cronica*.
Compute DNC78=-1.
Compute DNA78=-1.
Compute DNG78=-1.
execute.

If(zha78 <-2)DNC78=100.
If(zha78 >=-2)DNC78=0.
If (sysmis (zha78)=1)DNC78=-1.
Recode DNC78 (-1=sysmis).

If(zwh78 <-2)DNA78=100.
If(zwh78 >=-2)DNA78=0.
If (sysmis (zwh78)=1)DNA78=-1.
Recode DNA78 (-1=sysmis).

If(zwa78 <-2)DNG78=100.
If(zwa78 >=-2)DNG78=0.
If (sysmis (zwa78)=1)DNG78=-1.
Recode DNG78 (-1=sysmis).
execute.

*Prevalencia de sobrepeso*.
Compute SOBPESO78=-1.
If(zwh78 >2)SOBPESO78=100.
If(zwh78 <=2)SOBPESO78=0.
If (sysmis (zwh78)=1)SOBPESO78=-1.
Recode SOBPESO78 (-1=sysmis).
execute.

Vari label DNC78 'Desnutrido Cronico NCHS 1978'.
Vari label DNA78 'Desnutrido Agudo NCHS 1978'.
Vari label DNG78 'Desnutrido Global NCHS 1978'.
Vari label SOBPESO78 'Sobrepeso NCHS 1978'.

SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.


*-------------------------------------------------------------------------------------------------------------------------------------------------------------- *.
*			Ajuste de Hemoglobina por altura msnm							     *.
*	Adoptado de la formula de CDC/PNSS y Dirren. Las mediciones iniciales del nivel de hemoglobina llevadas al nivel del mar   *.
*----------- Formula: Hemoglobina ajustada=hemoglobina observada -ajuste por altura ---------------------------------------------------------*.
*--------------------------------------------------------------------------------------------------------------------------------------------------------------*.
Missing value c106 (99).
Missing value altitud (9999).
compute ajuste=0.022*((altitud/1000)*3.3*(altitud/1000)*3.3) - (0.032*((altitud/1000)*3.3)).
Vari label ajuste 'Factor de ajuste para correccion de la hemoglobina por altura'.
execute.
compute hbAju=C106-ajuste.
Vari label hbAju 'Hemoglobina corregida'.
execute.
if(sysmis(c106)=1)hbaju=-1.
recode hbAju(-1=sysmis).
execute.

*------------------------------------------------------------------------------------------------------------------*.
*                       CALCULO DE LA VARIABLE ANEMIA                                                              *.
*------------------------------------------------------------------------------------------------------------------*.
compute anem_nin=-1.
Vari label anem_nin 'Anemia <5 aos'.
Value label anem_nin 100'Si'  0'No'.
Missing value anem_nin (-1).
Format anem_nin (f3.0).
If(hbAju<=8.90 & (EdadMes>=0 and EdadMes<=3))anem_nin=100.
If(hbAju>8.90 & (EdadMes>=0 and EdadMes<=3))anem_nin=0.
If(hbAju<=10.40 & (EdadMes>3 and EdadMes<=6))anem_nin=100.
If(hbAju>10.40 & (EdadMes>3 and EdadMes<=6))anem_nin=0.
If(hbAju<=10.90 & ((EdadMes>=7 and EdadMes<=23)or EdadAno=1))anem_nin=100.
If(hbAju>10.90 & ((EdadMes>=7 and EdadMes<=23) or EdadAno=1))anem_nin=0.
If(hbAju<=11.40 & ((EdadMes>=24 and EdadMes<=59) OR EdadAno=2))anem_nin=100.
If(hbAju>11.40 & (EdadMes>=24 and EdadMes<=59))anem_nin=0.
execute.
Recode anem_nin (-1=sysmis).
execute.
*Calculo de la variable anemia en MEF*.
compute anem_mef=-1.
If(hbAju<=11.90 and SEXO=2 and (EdadAno>=15 and EdadAno<=49) and ( C109<>1 or C109<>3) ) anem_mef=100.
If(hbAju>11.90 and SEXO=2 and (EdadAno>=15 and EdadAno<=49) and ( C109<>1 or C109<>3) ) anem_mef=0.
If(hbAju<=10.90 and SEXO=2 and (EdadAno>=15 and EdadAno<=49) and ( C109=1 or C109=3) ) anem_mef=100.
If(hbAju>10.90 and SEXO=2 and (EdadAno>=15 and EdadAno<=49) and ( C109=1 or C109=3) ) anem_mef=0.
execute.

If(sysmis(hbAju)=1)anem_mef=-1.
recode anem_mef(-1=sysmis).
execute.
Vari label anem_mef 'Anemia MEF '.
Value label anem_mef 100'Si'  0'No'.
execute.

SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.

*------------------------------------------------------------------------------------------------------------------------*.
*                       SE CALCULA IMC: Utiliza el indice de QUETELET: IMC=Peso(kg)/(Talla(m))*(Talla(m))                *.
*Los puntos de corte para la clasificacion del Estado de Nutricion segn el IMC se basa en la                            *.
*Fuente: WHO Technical Report Series Nro 854. The use and the interpretation of anthropometry. Ginebra 1995.             *.
*------------------------------------------------------------------------------------------------------------------------*.

*********************************************************************************.
*     Se encontraron 99 missing en fecha de nacimiento, en estos missing se     *.
*     tomara la edad de la variable C101_EDAD_ANIO                              *.
*********************************************************************************.
If (sysmis(C112A=1) or sysmis(C112B=1) or sysmis(C112C=1))EdadAno= C101_EDAD_ANIO.
execute.

compute imc= C104 *10000/(C107*C107).
Vari label imc 'Indice de Masa Corporal'.
execute.
compute imc=trunc(imc*10)/10.
execute.

if (EdadAno<10) imc=-1.
execute.
recode imc(-1=sysmis).
execute.
  
valu label sexo
1 'Varon'
2'Mujer'.

Recode imc (100 thruw highest=-1).
execute.
Recode imc (lowest thruw 10=-1).
execute.
Recode imc (-1=sysmis).
execute.

compute dxIMC1=-1.
execute.

if (EdadAno=10 and Sexo=1 and imc<=14.4)dxIMC1=1.	
if (EdadAno=11 and Sexo=1 and imc<=14.8)dxIMC1=1.	
if (EdadAno=12 and Sexo=1 and imc<=15.2)dxIMC1=1.	
if (EdadAno=13 and Sexo=1 and imc<=15.7)dxIMC1=1.	
if (EdadAno=14 and Sexo=1 and imc<=16.2)dxIMC1=1.	
if (EdadAno=15 and Sexo=1 and imc<=16.6)dxIMC1=1.	
if (EdadAno=16 and Sexo=1 and imc<=17)dxIMC1=1.	
if (EdadAno=17 and Sexo=1 and imc<=17.36)dxIMC1=1.	
if (EdadAno=18 and Sexo=1 and imc<=17.5)dxIMC1=1.	
if (EdadAno=19 and Sexo=1 and imc<=17.8)dxIMC1=1.	
if (EdadAno=20 and Sexo=1 and imc<=18.9)dxIMC1=1.	
if (EdadAno=21 and Sexo=1 and imc<=18.9)dxIMC1=1.	
if (EdadAno=22 and Sexo=1 and imc<=18.9)dxIMC1=1.	
if (EdadAno=23 and Sexo=1 and imc<=18.9)dxIMC1=1.	
if (EdadAno=24 and Sexo=1 and imc<=18.9)dxIMC1=1.	
if (EdadAno=10 and Sexo=2 and imc<=14.2)dxIMC1=1.	
if (EdadAno=11 and Sexo=2 and imc<=14.6)dxIMC1=1.	
if (EdadAno=12 and Sexo=2 and imc<=15)dxIMC1=1.	
if (EdadAno=13 and Sexo=2 and imc<=15.4)dxIMC1=1.	
if (EdadAno=14 and Sexo=2 and imc<=15.7)dxIMC1=1.	
if (EdadAno=15 and Sexo=2 and imc<=16)dxIMC1=1.	
if (EdadAno=16 and Sexo=2 and imc<=16.4)dxIMC1=1.	
if (EdadAno=17 and Sexo=2 and imc<=16.6)dxIMC1=1.	
if (EdadAno=18 and Sexo=2 and imc<=16.7)dxIMC1=1.	
if (EdadAno=19 and Sexo=2 and imc<=16.9)dxIMC1=1.	
if (EdadAno=20 and Sexo=2 and imc<=17.4)dxIMC1=1.	
if (EdadAno=21 and Sexo=2 and imc<=17.4)dxIMC1=1.	
if (EdadAno=22 and Sexo=2 and imc<=17.4)dxIMC1=1.	
if (EdadAno=23 and Sexo=2 and imc<=17.4)dxIMC1=1.	
if (EdadAno=24 and Sexo=2 and imc<=17.4)dxIMC1=1.	
execute.	

if (EdadAno=10 and Sexo=1 and imc>14.4 and  imc<19.6)dxIMC1=2.	
if (EdadAno=11 and Sexo=1 and imc>14.8 and  imc<20.4)dxIMC1=2.	
if (EdadAno=12 and Sexo=1 and imc>15.2 and  imc<21.1)dxIMC1=2.	
if (EdadAno=13 and Sexo=1 and imc>15.7 and  imc<21.9)dxIMC1=2.	
if (EdadAno=14 and Sexo=1 and imc>16.2 and  imc<22.8)dxIMC1=2.	
if (EdadAno=15 and Sexo=1 and imc>16.6 and  imc<23.6)dxIMC1=2.	
if (EdadAno=16 and Sexo=1 and imc>17 and  imc<24.5)dxIMC1=2.	
if (EdadAno=17 and Sexo=1 and imc>17.36 and  imc<25.3)dxIMC1=2.	
if (EdadAno=18 and Sexo=1 and imc>17.5 and  imc<25.9)dxIMC1=2.	
if (EdadAno=19 and Sexo=1 and imc>17.8 and  imc<26.4)dxIMC1=2.	
if (EdadAno=20 and Sexo=1 and imc>18.9 and  imc<26.9)dxIMC1=2.	
if (EdadAno=21 and Sexo=1 and imc>18.9 and  imc<26.9)dxIMC1=2.	
if (EdadAno=22 and Sexo=1 and imc>18.9 and  imc<26.9)dxIMC1=2.	
if (EdadAno=23 and Sexo=1 and imc>18.9 and  imc<26.9)dxIMC1=2.	
if (EdadAno=24 and Sexo=1 and imc>18.9 and  imc<26.9)dxIMC1=2.	
if (EdadAno=10 and Sexo=2 and imc>14.2 and  imc<19.6)dxIMC1=2.	
if (EdadAno=11 and Sexo=2 and imc>14.6 and  imc<20.4)dxIMC1=2.	
if (EdadAno=12 and Sexo=2 and imc>15 and  imc<21.1)dxIMC1=2.	
if (EdadAno=13 and Sexo=2 and imc>15.4 and  imc<21.9)dxIMC1=2.	
if (EdadAno=14 and Sexo=2 and imc>15.7 and  imc<22.8)dxIMC1=2.	
if (EdadAno=15 and Sexo=2 and imc>16 and  imc<23.6)dxIMC1=2.	
if (EdadAno=16 and Sexo=2 and imc>16.4 and  imc<24.5)dxIMC1=2.	
if (EdadAno=17 and Sexo=2 and imc>16.6 and  imc<25.3)dxIMC1=2.	
if (EdadAno=18 and Sexo=2 and imc>16.7 and  imc<25.9)dxIMC1=2.	
if (EdadAno=19 and Sexo=2 and imc>16.9 and  imc<26.4)dxIMC1=2.	
if (EdadAno=20 and Sexo=2 and imc>17.4 and  imc<26.9)dxIMC1=2.	
if (EdadAno=21 and Sexo=2 and imc>17.4 and  imc<26.9)dxIMC1=2.	
if (EdadAno=22 and Sexo=2 and imc>17.4 and  imc<26.9)dxIMC1=2.	
if (EdadAno=23 and Sexo=2 and imc>17.4 and  imc<26.9)dxIMC1=2.	
if (EdadAno=24 and Sexo=2 and imc>17.4 and  imc<26.9)dxIMC1=2.	
execute.

if (EdadAno=10 and Sexo=1 and imc>=19.6)dxIMC1=3.	
if (EdadAno=11 and Sexo=1 and imc>=20.4)dxIMC1=3.	
if (EdadAno=12 and Sexo=1 and imc>=21.1)dxIMC1=3.	
if (EdadAno=13 and Sexo=1 and imc>=21.9)dxIMC1=3.	
if (EdadAno=14 and Sexo=1 and imc>=22.8)dxIMC1=3.	
if (EdadAno=15 and Sexo=1 and imc>=23.6)dxIMC1=3.	
if (EdadAno=16 and Sexo=1 and imc>=24.5)dxIMC1=3.	
if (EdadAno=17 and Sexo=1 and imc>=25.3)dxIMC1=3.	
if (EdadAno=18 and Sexo=1 and imc>=25.9)dxIMC1=3.	
if (EdadAno=19 and Sexo=1 and imc>=26.4)dxIMC1=3.	
if (EdadAno=20 and Sexo=1 and imc>=26.9)dxIMC1=3.	
if (EdadAno=21 and Sexo=1 and imc>=26.9)dxIMC1=3.	
if (EdadAno=22 and Sexo=1 and imc>=26.9)dxIMC1=3.	
if (EdadAno=23 and Sexo=1 and imc>=26.9)dxIMC1=3.	
if (EdadAno=24 and Sexo=1 and imc>=26.9)dxIMC1=3.	
if (EdadAno=10 and Sexo=2 and imc>=20.2)dxIMC1=3.	
if (EdadAno=11 and Sexo=2 and imc>=21.2)dxIMC1=3.	
if (EdadAno=12 and Sexo=2 and imc>=22.2)dxIMC1=3.	
if (EdadAno=13 and Sexo=2 and imc>=23.1)dxIMC1=3.	
if (EdadAno=14 and Sexo=2 and imc>=23.9)dxIMC1=3.	
if (EdadAno=15 and Sexo=2 and imc>=24.3)dxIMC1=3.	
if (EdadAno=16 and Sexo=2 and imc>=24.7)dxIMC1=3.	
if (EdadAno=17 and Sexo=2 and imc>=25.2)dxIMC1=3.	
if (EdadAno=18 and Sexo=2 and imc>=25.6)dxIMC1=3.	
if (EdadAno=19 and Sexo=2 and imc>=25.9)dxIMC1=3.	
if (EdadAno=20 and Sexo=2 and imc>=26.1)dxIMC1=3.	
if (EdadAno=21 and Sexo=2 and imc>=26.1)dxIMC1=3.	
if (EdadAno=22 and Sexo=2 and imc>=26.1)dxIMC1=3.	
if (EdadAno=23 and Sexo=2 and imc>=26.1)dxIMC1=3.	
if (EdadAno=24 and Sexo=2 and imc>=26.1)dxIMC1=3.	
execute.

if(C101_EDAD_ANIO>=25 and range(imc,0,18.5)=1)dxIMC1=1.	
if(C101_EDAD_ANIO>=25 and range(imc,18.5,24.99)=1)dxIMC1=2.	
if(C101_EDAD_ANIO>=25 and range(imc,25,29.99)=1)dxIMC1=4.	
if(C101_EDAD_ANIO>=25 and range(imc,30,34.99)=1)dxIMC1=5.	
if(C101_EDAD_ANIO>=25 and range(imc,35,39.99)=1)dxIMC1=6.	
if(C101_EDAD_ANIO>=25 and range(imc,40,1000)=1)dxIMC1=7.	
execute.

recode dxIMC1(-1=sysmis).
execute.
vari label dxIMC1'Estado Nutricional (en mayores 10aos)'.
valu label dxIMC1
1'Adelgazado'
2'Normal'
3'Riesgo sobrepeso'
4'Preobeso'
5'Obeso clase I'
6'Obeso clase II'
7'Obeso clase III'.
execute.

compute dxIMC2=dxIMC1.
If(dxIMC1>=3)dxIMC2=3.
Vari label dxIMC2 'Estado Nutricional >10aos'.
Value label dxIMC2 
1'Adelgazada'
2'Normal'
3'Exceso de peso'.
execute.


SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.


*----------------------------------------------------------------------------------------------------*.
*           Calculo del zScore segun tablas de referencia OMS 2006                                   *.
*----------------------------------------------------------------------------------------------------*.
*Nombre de las variables: FecEnc,FecNac,Peso, talla,sexo,metodo [1=echado,2=de pie]*.

*Verificar los Paths ( FILE HANDLE)*.
FILE HANDLE DATOS1     /NAME='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO'.
FILE HANDLE WHO	  /NAME='C:\06 CENAN\04 UINutricional\08 ENAHO\99 zAntroWHO2006'.


* Compute FecEnc= [Ya existe].
Compute Peso=C104.
Compute Talla=C107.
*Compute Sexo=[Ya existe].
compute metodo=-1.
if(C108=2)metodo=1.
if(C108=1)metodo=2.
recode metodo(-1=sysmis).
execute.

Vari label
Peso 'Peso(kg)'
talla 'Talla(cm)'
sexo 'Sexo'
metodo 'Metodo[1=echado,2=de pie]' .
execute.
INSERT FILE='WHO\zAntroWHO2006.sps'.

execute.
*************************************************.
GET FILE='DATOS1\zAntroNinosWHO2006.sav'.
SORT CASES BY
CONGLOME VIVIENDA HOGAR CODPERSO (A) .
SAVE OUTFILE='DATOS1\zAntroNinosWHO2006.sav'.

GET FILE='DATOS1\AntroENAHOIV2007.sav'.
SORT CASES BY
CONGLOME VIVIENDA HOGAR CODPERSO (A) .

MATCH FILES /FILE=*
/TABLE='DATOS1\zAntroNinosWHO2006.sav'
/BY CONGLOME VIVIENDA HOGAR CODPERSO.
execute.

*Calculo de las variables de Desnutricion cronica con tabla de referencia OMS 2006.
Compute DNC06=-1.
Compute DNA06=-1.
Compute DNG06=-1.
execute.

If(zhaz <-2)DNC06=100.
If(zhaz >=-2)DNC06=0.
If (sysmis (zhaz)=1)DNC06=-1.
Recode DNC06 (-1=sysmis).

If(zwhz <-2)DNA06=100.
If(zwhz >=-2)DNA06=0.
If (sysmis (zwhz)=1)DNA06=-1.
Recode DNA06 (-1=sysmis).

If(zwaz <-2)DNG06=100.
If(zwaz >=-2)DNG06=0.
If (sysmis (zwaz)=1)DNG06=-1.
Recode DNG06 (-1=sysmis).
execute.

*Prevalencia de sobrepeso*.
Compute SOBPESO06=-1.
If(zwhz >2)SOBPESO06=100.
If(zwhz <=2)SOBPESO06=0.
If (sysmis (zwhz)=1)SOBPESO06=-1.
Recode SOBPESO06 (-1=sysmis).
execute.

Vari label DNC06 'Desnutrido Cronico OMS-2006'.
Vari label DNA06 'Desnutrido Agudo OMS-2006'.
Vari label DNG06 'Desnutrido Global OMS-2006'.
Vari label SOBPESO06 'Sobrepeso OMS-2006'.
Value label  DNC78 DNA78  DNG78 SOBPESO78 DNC06 DNA06 DNG06 SOBPESO06 0'No'  100'Si'.
execute.


***Crear variable: Nios desnutridos Anemicos*.
compute nin_dcane=-1.
If(EdadAno>=0 and EdadAno<=4)nin_dcane=0.
If(DNC06=100 & anem_nin=100 & (EdadAno>=0 and EdadAno<=4))nin_dcane=100.
recode nin_dcane (-1=sysmis).
execute.

*Marcar los hogares con al menos 1 nino menor de 5 aos*.
 compute nino=0.
If(EdadAno>=0 and EdadAno<=4)nino=1.
Vari label nino'Numero de Nios'.
execute.
 

****Crear variable NBI*.
compute NBI=sum(NBI1, NBI2, NBI3, NBI4, NBI5).
execute.

Recode NBI (2=1) (3=2) (4=2) (5=2).
execute.
Vari label NBI 'NBI'.
Valu label NBI 0  'Sin NBI'   1 '<3NBI'   2 '>3NBI'.
execute.

string ccdd (a2).
compute ccdd=substring(UBIGEO,1,2).
VARIABLE LABELS ccdd 'Departamento' .
EXECUTE .

compute AREA1=0.
If(ESTRATO<=5)AREA1=1.
If(ESTRATO>5)AREA1=2.
execute.
Vari label AREA1 'AREA'.
Value label AREA1 1'Urbano' 2'Rural'. 

SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.

***Crear variable nio<5 aos con antropometria completa*.
*CONG  VIV 056 HOG 11  COSPERS 02: Solo tiene peso, no tiene talla--------------------------------------------------------*.

compute antrocomp= C102A.
If (CONGLOME='2467' & VIVIENDA='056' & HOGAR='11' & CODPERSO='02')antrocomp=4.
execute.  
Vari label antrocomp 'Resultado-Antropometria'.
Value label antrocomp 1'Completo'  2'Ausente'  3'Rechazo'  4'Incompleto'.
execute.
compute men5Antro=-1.
If(EdadAno>=0 & EdadAno<5)men5Antro=0.
If((EdadAno>=0 & EdadAno<5) & antrocomp=1)men5Antro=1.
execute.
Recode men5Antro (-1=sysmis).
execute.

compute m59Antro=-1.
If(EdadAno>=5 & EdadAno<=9)m59Antro=0.
If((EdadAno>=5 & EdadAno<=9) & antrocomp=1)m59Antro=1.
execute.
Recode m59Antro (-1=sysmis).
execute.

compute m1018Antro=-1.
If(EdadAno>=10 & EdadAno<18)m1018Antro=0.
If((EdadAno>=10 & EdadAno<18) & antrocomp=1)m1018Antro=1.
execute.
Recode m1018Antro (-1=sysmis).
execute.

compute may18Antro=-1.
If(EdadAno>=18)may18Antro=0.
If(EdadAno>=18 & antrocomp=1)may18Antro=1.
execute.
Recode may18Antro (-1=sysmis).
execute.

***Crear variable MEF con antropometria completa*.
If((EdadAno>=15 & EdadAno<=49)&sexo=2)mefAntro=0.
If((EdadAno>=15 & EdadAno<=49) & antrocomp=1 &sexo=2)mefAntro=1.
execute.
Recode mefAntro (-1=sysmis).
execute.
Vari label 
 EdaDec    'Edad decenios'
 men5Antro 'Menor 5 aos con antropometria'
 mefAntro  'MEF con antropometria'
 m59Antro  'Miembro 5-9 aos con antropometria'
 m1018Antro 'Miembro 10-17 aos con antropometria'
 may18Antro 'Miembro mayor 18 aos con antropometria'.

compute mef=0.
If((EdadAno>=15 & EdadAno<=49)&sexo=2)mef=1.
execute.

compute nino=-1.
If(EdadAno>=0 & EdadAno<5)nino=1.
If(EdadAno>=5)nino=0.
Recode nino (-1=sysmis).
execute.

compute m59=-1.
If(EdadAno>=5 & EdadAno<=9)m59=1.
If(EdadAno<5 OR EdadAno>9)m59=0.
Recode m59 (-1=sysmis).
execute.

compute men10=-1.
If(EdadAno<10)men10=1.
If(EdadAno>=10)men10=0.
Recode men10 (-1=sysmis).
execute.

compute may10=-1.
If(EdadAno>=10)may10=1.
If(EdadAno<10)may10=0.
Recode may10 (-1=sysmis).
execute.

compute m1018=-1.
If(EdadAno>=10 & EdadAno<18)m1018=1.
If(EdadAno<10 OR EdadAno>=18)m1018=0.
Recode m1018 (-1=sysmis).
execute.

compute may18=-1.
If(EdadAno>=18)may18=1.
If(EdadAno<18)may18=0.
execute.
Recode may18(-1=sysmis).
execute.
Vari label 
 m59 'Miembro 5-9aos'
 m1018 'Miembro 10-17 aos'
 may18 'Miembro >=18 aos'.

compute AREA=0.
If(ESTRATO<=5)AREA=1.
If(ESTRATO>5)AREA=2.
Vari label AREA'Area'.
Value label AREA 1'Urbano'  2'Rural'.
SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.
*--------------------------------------------------------------------------------------------------------------------------- *.
* S E    J U N T A N    L A S   T A B L A S MiembrosENAHOIV2007.sav (CONTIENE TODOS LOS MIEMBROS CAPTADOS POR INEI) C O N  	  *.
* L A   T A B L A   AntroENAHOIV2007.sav (CONTIENE TODOS LOS MIEMBROS CAPTADOS POR CENAN)						  *. 
*--------------------------------------------------------------------------------------------------------------------------- *.

GET FILE='DATOS1\MiembrosENAHOIV2007.sav'.
SORT CASES BY CONGLOME VIVIENDA HOGAR CODPERSO (A).
SAVE OUTFILE='DATOS1\MiembrosENAHOIV2007.sav'.

GET FILE='DATOS1\AntroENAHOIV2007.sav'.
MATCH FILES /FILE=*
 /FILE='DATOS1\MiembrosENAHOIV2007.sav'
 /IN=source01
 /BY CONGLOME VIVIENDA HOGAR CODPERSO.
VARIABLE LABELS source01
 'Case source is C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\MiembrosENAHOIV2007.sav'.
EXECUTE.

Recode jhNivEd (1=1) (2=1) (3=2) (4=2) (5=3) (6=3) (7 thruw highest =4) into  jhNivEd1.
Vari label jhNivEd1 'Nivel de educacin (Jefe hogar)'.
Value label jhNivEd1 1'Sin nivel' 2'Primaria' 3'Secundaria' 4'Superior'.
execute.

Recode jhIdiom (1=1) (2=3) (3=3) (4=2) (5 thruw highest =3) into jhIdiom1.
Vari label jhIdiom1 'Idioma (Jefe hogar)'.
Value label jhIdiom1 1'Quechua' 2'Castellano' 3'Otro'.
execute.

Recode jhEdad  (14 thruw 29=1) (30 thruw 44=2) (45 thruw 59=3) (60 thruw highest =4) into jhEdad1.
Vari label jhEdad1 'Edad (Jefe hogar)'.
Value label jhEdad1 1'14-29' 2'30-44' 3'45-59' 4'>60'.
execute.

*///////////////////Para filtrar a las tallas outlayers/////////////////*.
If(EdadAno>=1 & c107<=60)flagTalla=1.
If(EdadAno<=1 & c107>=100)flagTalla=1.
If(EdadAno<=5 & c104>=40)flagPeso=1.
If(EdadAno>=5 & c104<=10)flagPeso=1.
execute.
compute pC104=C104.
compute pC107=C107.
execute.
If(flagTalla=1)pC107=-1.
If(flagPeso=1)pC104=-1.
execute.
Recode pc107 (-1=SYSMIS).
Recode pC104(-1=SYSMIS).
EXECUTE.
SAVE OUTFILE='DATOS1\AntroENAHOIV2007.sav'.


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*																			      *.
*	 T A B U L A D O S    C E N A N - A N T R O P O M E T R I A     E N A H O						                    *.
*																			      *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*----------------------------------------------------------------------------------------------------------------*.
*           Creamos el archivo ENAHO2007.CSPLAN y enaho2007Hogar.csaplan 
*ENAHO por ser una muestra compleja: Estos archivos permitiran calcular la precision de los Errores estandares de los indicadores *.
*-----------------------------------------------------------------------------------------------------------------*.
* Analysis Preparation Wizard.
CSPLAN ANALYSIS
 /PLAN FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /PLANVARS ANALYSISWEIGHT=FACPOTRI
 /PRINT PLAN
 /DESIGN  STRATA= ccdd  CLUSTER= CONGLOME
   /ESTIMATOR TYPE=WR.

* Analysis Preparation Wizard.
CSPLAN ANALYSIS
 /PLAN FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /PLANVARS ANALYSISWEIGHT=FACTCENAN
 /PRINT PLAN
 /DESIGN  STRATA= ccdd  CLUSTER= CONGLOME
   /ESTIMATOR TYPE=WR.


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*                TABULADOS:   CAPITULO III: ESTADO NUTRICIONAL EN NIOS MENORES DE 5 AOS					         *.
*	          		ESTADO NUTRICIONAL <5 AOS							                                       *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
**------------------------fILTRAR A LOS NIOS MENORES DE 5 AOS  --------------------------*

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***------------------------DNC 1978 versus variables----------------------.

USE ALL.
COMPUTE filter_$=(EdadAno < 5).
VARIABLE LABEL filter_$ 'EdadAno < 5 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhSexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

***--------------------------------DNA 1978 versus variables--------------------.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***---------------------------------DNG 1978 versus variables--------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***---------------------------SOBREPESO 1978 versus variables------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*******--------------------------DNC 2006-----------------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC06
 /SUBPOP TABLE = jhSexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*******--------------------------DNA 2006-------------------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA06
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*******--------------------------DNG 2006---------------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG06
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*******--------------------------SOBREPESO 2006--------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO06
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*	TABULADOS: CAPITULO IV: ESTADO NUTRICIONAL DE LOS MIEMBROS DEL HOGAR DE 5 A MS AOS	                		*.
*	          		ESTADO NUTRICIONAL 5-9 AOS							      *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
**------------------------fILTRAR A LOS NIOS DE 5-9 AOS  --------------------------*

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***------------------------DNC 1978 versus variables----------------------.
USE ALL.
COMPUTE filter_$=(EdadAno >= 5 & EdadAno <= 9).
VARIABLE LABEL filter_$ 'EdadAno >= 5 & EdadAno <= 9 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNC78
 /SUBPOP TABLE = jhSexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***--------------------------------DNA 1978 versus variables--------------------.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNA78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***---------------------------------DNG 1978 versus variables--------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = DNG78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
***---------------------------SOBREPESO 1978 versus variables------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = SOBPESO78
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*                                 TABULADOS: ESTADO NUTRICIONAL EN MIEMBROS DEL HOGAR MAYORES DE >=10AOS 					   *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*------------------------            PARA MUJERES   					--------------------------------------------*.
      
*Filtramos a las mujeres*.

USE ALL.
COMPUTE filter_$=(sexo=2 & EdadAno >= 10).
VARIABLE LABEL filter_$ 'sexo=2 & EdadAno >= 10 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC1 
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC1 
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC1 
 /SUBPOP TABLE = ESTRATO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC1 
 /SUBPOP TABLE = EdaDec  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC1 
 /SUBPOP TABLE =  Ngasper   DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC1 
 /SUBPOP TABLE =  POBREZA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC2 
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC2 
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC2 
 /SUBPOP TABLE = ESTRATO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC2 
 /SUBPOP TABLE = EdaDec  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC2 
 /SUBPOP TABLE =  Ngasper   DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = dxIMC2 
 /SUBPOP TABLE =  POBREZA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*------------------------ TABULADOS PARA HOMBRES--------------------------------------------------*.
*Filtramos a los hombres y luego repetimos las tablas igual que para mujeres*.

USE ALL.
COMPUTE filter_$=(sexo=1 & EdadAno >= 10).
VARIABLE LABEL filter_$ 'sexo=1 & EdadAno >= 10 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*	TABULADOS: CAPITULO V: ANEMIA DE LOS NIOS MENORES DE 3 AOS Y LAS MUJERES EN EDAD FERTIL (15-49 AOS)      *.	
*																			       *.
*                                            ANEMIA EN NIOS DE 6-59 MESES (Se considera este rango de edad debido a que la   *.
* prevalencia de anemia en menores de 6 meses es baja (para este caso es de 23% aproximadamente por lo que si se considera    *.
* este rango de edad bajaria la prevalencia ) 												   *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

USE ALL.
COMPUTE filter_$=(EdadMes >= 6 & EdadMes <= 59).
VARIABLE LABEL filter_$ 'EdadMes >= 6 & EdadMes <= 59 (FILTER)'.
VALUE LABELS filter_$  0 'Not Selected' 1 'Selected'.
FORMAT filter_$ (f1.0).
FILTER BY filter_$.
EXECUTE .

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin 
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin
 /SUBPOP TABLE = sexo  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin
 /SUBPOP TABLE = EdadAno  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_nin
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*                                            ANEMIA EN MEF											      *.
*																			      *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_mef
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_mef
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_mef
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_mef
 /SUBPOP TABLE = EdaQui DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_mef
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = anem_mef
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
* 			CAPITULO VI: ACTIVIDAD FSICA EN LOS MIEMBROS DEL HOGAR DE 14 A MS AOS				*.	
*																			      *.
*                                            ACTIVIDAD FISICA 										      *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

*C114 Cul de las siguientes respuestas describe mejor la forma en que se desarrolla su trabajo u otra actividad en la que se ocupa?*.
*------------------------------------------------------------------------------------------------------------------------------------*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C114
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C114
 /SUBPOP TABLE = sexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C114
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C114
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C114
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*---------------------------------------------------------------------------------------------------------------------------- *.
*C115 Complementa sus actividades habituales con EJERCICIOS ADICIONALES U OTRA ACTIVIDAD FISICA O DEPORTE?*.
*------------------------------------------------------------------------------------------------------------------------------------*.
* Complex Samples Crosstabs.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115 BY Ngasper
 /CELLS  ROWPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Crosstabs.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115 BY sexo
 /CELLS  ROWPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Crosstabs.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115 BY ESTRATO
 /CELLS  ROWPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Crosstabs.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115 BY AREA
 /CELLS  ROWPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Crosstabs.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115 BY DOMINIO
 /CELLS  ROWPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Crosstabs.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115 BY EdaDec
 /CELLS  ROWPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.


* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = ESTRATO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = sexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = Ngasper DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = POBREZA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = DOMINIO DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007.csaplan'
 /TABLES VARIABLES = C115
 /SUBPOP TABLE = EdaDec DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.


*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
* CAPITULO VIII: CARACTERIZACIN ANTROPOMTRICA DE LOS HOGARES DE ACUERDO AL BINOMIO NIO-MUJER EN EDAD FRTIL*.
*																			      *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
AGGREGATE
  /OUTFILE=*
  MODE=ADDVARIABLES
  /BREAK=AO MES CONGLOME VIVIENDA HOGAR
  /mef_sum_1 = SUM(mef) /nino_sum_1 = SUM(nino).

*Se calcula la variable hogar con mef y nio////////////*.
compute mef_nino=sum(mef_sum_1,nino_sum_1).
execute.
Vari label  mef_nino 'Hogar con MEF y NIO'.
execute.

sele if mef_nino>=2.
execute.
sele if mef_sum_1>0.
execute.
sele if nino_sum_1>0.
execute.

SAVE OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AntroENAHOIV2007Mef_Nino.sav'
 /COMPRESSED.

GET
  FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AntroENAHOIV2007Mef_Nino.sav'.
Recode mef(0=sysmis).
execute.

compute mef_obe1=-1.
If(mef=1 & dxIMC2=3)mef_obe1=1.
execute.
If(mef=1 & dxIMC2<3)mef_obe1=0.
execute.
Recode mef_obe1 (-1=sysmis).
execute.

compute mef_obane1=-1.
If(mef_obe1=1 & anem_mef=100)mef_obane1=1.
If(mef_obe1=0 & anem_mef=100)mef_obane1=0.
If(mef_obe1=1 & anem_mef=0)mef_obane1=0.
If(mef_obe1=0 & anem_mef=0)mef_obane1=0.
execute.
Recode mef_obane1 (-1=sysmis).
execute.

compute mef_del=-1.
If(mef=1 & dxIMC2=1)mef_del=1.
execute.
If(mef=1 & dxIMC2>1)mef_del=0.
execute.
Recode mef_del (-1=sysmis).
execute.

compute mef_delane1=-1.
If(mef_del=1 & anem_mef=100)mef_delane1=1.
If(mef_del=0 & anem_mef=100)mef_delane1=0.
If(mef_del=1 & anem_mef=0)mef_delane1=0.
If(mef_del>1 & anem_mef=0)mef_delane1=0.
execute.
Recode mef_delane1 (-1=sysmis).
execute.

Recode anem_nin(-1=sysmis).
execute.
If(nino <>1)anem_nin=-1.
execute.

compute nin_dcane=-1.
If(nino=1 & DNC06=100 & anem_nin=100)nin_dcane=1.
If(nino=1 & DNC06=0 & anem_nin=100)nin_dcane=0.
If(nino=1 & DNC06=100 & anem_nin=0)nin_dcane=0.
If(nino=1 & DNC06=0 & anem_nin=0)nin_dcane=0.
Recode nin_dcane(-1=sysmis).
execute.
 
Vari label 
mef_obe1 'Mef 15-49a c/Sobrepeso de acuerdo a Edad'
mef_obane1 'Mef 15-49a c/sobrepeso + anemia'
nin_dcane 'Nio menor 5 aos DNC +Anemia'
mef_delane1 'Mef delgada +anemia'.
execute.
SAVE OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AntroENAHOIV2007MEF_NINO.sav'
 /COMPRESSED.


AGGREGATE
  /OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggAntroENAHOIV2007HogaresMEF_NINO1.sav'
  /BREAK=AO MES CONGLOME VIVIENDA HOGAR UBIGEO DOMINIO ESTRATO ALTITUD FACTCENAN NVISITA ccdd FecEnc RESULT RESULTADO
  AREA
/FAC_HOG = MEAN(FAC_HOG) 
/P101 = MEAN(P101) 
/P102 = MEAN(P102) 
/P103 = MEAN(P103)  
/P103A = MEAN(P103A) 
/P104 = MEAN(P104) 
/P104A = MEAN(P104A)  
/P110 = MEAN(P110) 
/P111 = MEAN(P111) 
/P1121 = MEAN(P1121) 
/P1122 = MEAN(P1122) 
/P1123 = MEAN(P1123) 
/P1124 = MEAN(P1124) 
/P1125 = MEAN(P1125)
/P1126 = MEAN(P1126) 
/P1127 = MEAN(P1127) 
/P112A = MEAN(P112A) 
/P1131 = MEAN(P1131) 
/P1132 = MEAN(P1132) 
/P1133 = MEAN(P1133) 
/P1134 = MEAN(P1134) 
/P1135 = MEAN(P1135) 
/P1136 = MEAN(P1136)
/P1137 = MEAN(P1137) 
/P1138 = MEAN(P1138) 
/P701 = MEAN(P701) 
/Ngasper = MEAN(Ngasper) 
/POBREZA = MEAN(POBREZA) 
/NTI001 = MEAN(NTI001) 
/MIEPERHO = MEAN(MIEPERHO) 
/TOTMIEHO = MEAN(TOTMIEHO) 
/PERCEPHO = MEAN(PERCEPHO) 
/jhEdad = MEAN(jhEdad) 
/jhSexo = MEAN(jhSexo) 
/jhNivEd = MEAN(jhNivEd) 
/jhIdiom = MEAN(jhIdiom) 
/jhNivEd1 = MEAN(jhNivEd1) 
/jhIdiom1 = MEAN(jhIdiom1) 
/jhEdad1 = MEAN(jhEdad1) 
/mef_sum = MEAN(mef_sum_1)
/nino_sum = MEAN(nino_sum_1) 
/nin_dcane = SUM(nin_dcane) 
/mef_del = SUM(mef_del) 
/mef_obane1 = SUM(mef_obane1)
/mef_delane1 = SUM(mef_delane1)  
/anem_nin = SUM(anem_nin) 
/anem_mef = SUM(anem_mef) 
/mef_obe1 = SUM(mef_obe1) 
/DNC06 = SUM(DNC06) 
/SOBPESO06 = SUM(SOBPESO06) 
/SOBPESO78 = SUM(SOBPESO78).

GET FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggAntroENAHOIV2007HogaresMEF_NINO1.sav'.
Compute nin_dcane2=nin_dcane.	
Compute mef_del2=mef_del.	
Compute mef_obane2=mef_obane1.	
Compute mef_delane2=mef_obane1.	
Compute anem_nin2=anem_nin.	
Compute anem_mef2=anem_mef.	
Compute mef_obe2=mef_obe1.	
Compute DNC062=DNC06.	
Compute SOBPESO062=SOBPESO06.	
Compute SOBPESO782=SOBPESO78.	
execute.

Recode nin_dcane2 (1 thruw highest=1).
Recode mef_obane2 (1 thruw highest=1).
Recode mef_delane2 (1 thruw highest=1).
Recode mef_del2 (1 thruw highest=1).
Recode anem_nin2 (1 thruw highest=1).
Recode anem_mef2 (1 thruw highest=1).
Recode mef_obe2 (1 thruw highest=1).
Recode DNC062 (1 thruw highest=1).
Recode SOBPESO062 (1 thruw highest=1).
Recode SOBPESO782 (1 thruw highest=1).
execute.

*/////////////////////////////////////////////////*.
compute hog_dcdel=-1.
If(DNC062=1 & MEF_DEL2=1)hog_dcdel=1.
If(DNC062=0 & MEF_DEL2=1)hog_dcdel=0.
If(DNC062=1 & MEF_DEL2=0)hog_dcdel=0.
If(DNC062=0 & MEF_DEL2=0)hog_dcdel=0.
EXECUTE.

Recode hog_dcdel (-1=sysmis).
execute.

compute hog_dcobe=-1.
If(DNC062=1 & MEF_obe2=1)hog_dcobe=1.
If(DNC062=1 & MEF_obe2=0)hog_dcobe=0.
If(DNC062=0 & MEF_obe2=1)hog_dcobe=0.
If(DNC062=0 & MEF_obe2=0)hog_dcobe=0.
EXECUTE.

Recode hog_dcobe (-1=sysmis).
execute.

compute hog_sobobe=-1.
If(SOBPESO062=1 & MEF_obe2=1)hog_sobobe=1.
If(SOBPESO062=0 & MEF_obe2=1)hog_sobobe=0.
If(SOBPESO062=1 & MEF_obe2=0)hog_sobobe=0.
If(SOBPESO062=0 & MEF_obe2=0)hog_sobobe=0.
EXECUTE.

Recode hog_sobobe (-1=sysmis).
execute.

compute hog_dcaneobe=-1.
If(nin_dcane2=1 & MEF_obe2=1)hog_dcaneobe=1.
If(nin_dcane2=0 & MEF_obe2=1)hog_dcaneobe=0.
If(nin_dcane2=1 & MEF_obe2=0)hog_dcaneobe=0.
If(nin_dcane2=0 & MEF_obe2=0)hog_dcaneobe=0.
EXECUTE.

Recode hog_dcaneobe (-1=sysmis).
execute.

compute hog_aneobe=-1.
If(anem_nin2=1 & MEF_obe2=1)hog_aneobe=1.
If(anem_nin2=0 & MEF_obe2=1)hog_aneobe=0.
If(anem_nin2=1 & MEF_obe2=0)hog_aneobe=0.
If(anem_nin2=0 & MEF_obe2=0)hog_aneobe=0.
EXECUTE.

Recode hog_aneobe (-1=sysmis).
execute.

compute hog_dcane=-1.
If(DNC062=1 & anem_mef2=1)hog_dcane=1.
If(DNC062=0 & anem_mef2=1)hog_dcane=0.
If(DNC062=1 & anem_mef2=0)hog_dcane=0.
If(DNC062=0 & anem_mef2=0)hog_dcane=0.
EXECUTE.

Recode hog_dcane (-1=sysmis).
execute.

compute hog_aneane=-1.
If(anem_nin2=1 & anem_mef2=1)hog_aneane=1.
If(anem_nin2=0 & anem_mef2=1)hog_aneane=0.
If(anem_nin2=1 & anem_mef2=0)hog_aneane=0.
If(anem_nin2=0 & anem_mef2=0)hog_aneane=0.
EXECUTE.

Recode hog_aneane (-1=sysmis).
execute.

SAVE OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggAntroENAHOIV2007HogaresMEF_NINO1.sav'
 /COMPRESSED.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
* CAPITULO VIII: CARACTERIZACIN ANTROPOMTRICA DE LOS HOGARES DE ACUERDO AL BINOMIO NIO-MUJER EN EDAD FRTIL*.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.


*/////Hogar Nino<5aos c/DNC+MEF DELAGADA////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_dcdel
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar Nino<5aos c/DNC+MEF C/EXCESO DE PESO////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_dcobe
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
*/////Hogar Nino<5aos c/DNC+MEF C/anemia////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_dcane
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar Nino<5aos c/sobrepeso+MEF C/EXCESO DE PESO////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sobobe
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar Nino<3aos c/anemia+MEF C/EXCESO DE PESO////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_aneobe
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar Nino<3aos c/anemia+MEF C/anemia////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_aneane
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar Nino<3aos c/anemia y DNC + MEF C/obesa////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_dcaneobe
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*		CAPITULO VII: CARACTERIZACIN DEL PERFIL NUTRICIONAL DE  LOS HOGARES	*.				          *.
*///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

compute men18=-1.
If(EdadAno<18)men18=1.
If(EdadAno>=18)men18=0.
Recode men18(-1=sysmis).
execute.

Vari label men18 'Menor de 18 aos'.
execute.
*////Hogar desnutrido/////////*.
compute men18DTE=-1.
If(men18=1 & DNC78=100)men18DTE=1.
If(men18=1 & DNC78=0)men18DTE=0.
Recode men18DTE (-1=SYSMIS).
EXECUTE.
compute may18dc=-1.
If(may18=1 & dxIMC2=1)may18dc=1.
If(may18=1 & dxIMC2>1)may18dc=0.
Recode may18dc (-1=SYSMIS).
EXECUTE.

compute may18SOB=-1.
If(may18=1 & dxIMC2=3)may18SOB=1.
If(may18=1 & dxIMC2<3)may18SOB=0.
Recode may18SOB (-1=SYSMIS).
EXECUTE.

*////////Para Hogar obeso//////////*.
compute men10SOB=-1.
If(men10=1 & SOBPESO78=100)men10SOB=1.
If(men10=1 & SOBPESO78=0)men10SOB=0.
Recode men10SOB (-1=SYSMIS).
EXECUTE.

compute may10SOB=-1.
If(may10=1 & dxIMC2=3)may10SOB=1.
If(may10=1 & dxIMC2<3)may10SOB=0.
Recode may10SOB (-1=SYSMIS).
EXECUTE.
compute nro_mie=1.
execute.

SAVE OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AntroENAHOIV2007.sav'
 /COMPRESSED.

AGGREGATE
  /OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggHogartotal.sav'
  /BREAK=CONGLOME VIVIENDA HOGAR UBIGEO  
/nro_mie 	= SUM(nro_mie) 
/mef	 	= SUM(mef) 
/nino 		= SUM(nino) 
/men18 	= SUM(men18) 
/may18 	= SUM(may18)
/men18DTE 	= SUM(men18DTE)
/men10 	= SUM(men10) 
/men10SOB 	= SUM(men10SOB) 
/may10 	= SUM(may10) 
/may10SOB 	= SUM(may10SOB) 
/may18dc 	= SUM(may18dc) 
/may18SOB 	= SUM(may18SOB) 
/anem_nin 	= SUM(anem_nin) 
/anem_mef 	= SUM(anem_mef).


GET FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggHogartotal.sav'.
compute hog_doble=-1.
If(men18>=1 & may18>=1)hog_doble=1.
If(men18=0 & may18>=1)hog_doble=0.
If(men18>=1 & may18=0)hog_doble=0.
execute.
Recode hog_doble(-1=sysmis).
execute.
sele if hog_doble=1.
execute.
SAVE OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggHogartotal1.sav'.

GET FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggHogartotal1.sav'.

*/////////Hogar sin malnutricion////////////////*.
compute hog_sinmal=-1.
If(men18DTE=0 & may10SOB=0 & men10SOB=0 & may18dc=0)hog_sinmal=1.
If(men18DTE>=1 & may18SOB=0 & men10SOB=0 & may18dc=0)hog_sinmal=0.
If(men18DTE>=1 & may18SOB=0 & men10SOB=0 & may18dc>=1)hog_sinmal=0.
If(men18DTE>=1 & may18SOB=0 & men10SOB>=1 & may18dc=0)hog_sinmal=0.
If(men18DTE>=1 & may18SOB=0 & men10SOB>=1 & may18dc>=1)hog_sinmal=0.
If(men18DTE=0 & may18SOB>=1 & men10SOB=0 & may18dc=0)hog_sinmal=0.
If(men18DTE=0 & may18SOB>=1 & men10SOB=0 & may18dc>=1)hog_sinmal=0.
If(men18DTE=0 & may18SOB>=1 & men10SOB>=1 & may18dc=0)hog_sinmal=0.
If(men18DTE=0 & may18SOB>=1 & men10SOB>=1 & may18dc>=1)hog_sinmal=0.
If(men18DTE>=1 & may18SOB>=1& men10SOB=0 & may18dc=0)hog_sinmal=0.
If(men18DTE>=1 & may18SOB>=1& men10SOB=0 & may18dc>=1)hog_sinmal=0.
If(men18DTE>=1 & may18SOB>=1& men10SOB>=1 & may18dc=0)hog_sinmal=0.
If(men18DTE>=1 & may18SOB>=1& men10SOB>=1 & may18dc>=1)hog_sinmal=0.
execute.
Recode hog_sinmal (-1=sysmis).
execute.

*/////////Hogar con dualidad global de malnutricin////////////////*.
compute me18DTETodos=-1.
If(men18DTE=men18)me18DTETodos=1. 
If(men18DTE>men18)me18DTETodos=0.
If(men18DTE<men18)me18DTETodos=0.
execute.
Recode me18DTETodos (-1=sysmis).
execute.

compute ma18SOBTodos=-1.
If(may18SOB=may18)ma18SOBTodos=1. 
If(may18SOB>may18)ma18SOBTodos=0.
If(may18SOB<may18)ma18SOBTodos=0.
execute.
Recode ma18SOBTodos (-1=sysmis).
execute.

compute hog_duaglobal=-1.
If(me18DTETodos=1 & ma18SOBTodos=1)hog_duaglobal=1.
If(me18DTETodos=1 & ma18SOBTodos=0)hog_duaglobal=0.
If(me18DTETodos=0 & ma18SOBTodos=1)hog_duaglobal=0.
If(me18DTETodos=0 & ma18SOBTodos=0)hog_duaglobal=0.
execute.
Recode hog_duaglobal (-1=sysmis).
execute.

*/////////Hogar con adultos c/sobrepeso////////////////*.
compute hog_adSOB=-1.
If(men18DTE=0 & may18SOB>=1)hog_adSOB=1.
If(men18DTE>=1 & may18SOB>=0)hog_adSOB=0.
If(men18DTE=0 & may18SOB=0)hog_adSOB=0.
execute.
Recode hog_adSOB (-1=sysmis).
execute.

*/////////Hogar con menores desnutridos////////////////*.
compute hog_menDTE=-1.
If(men18DTE>=1 & may18SOB=0)hog_menDTE=1.
If(men18DTE>=0 & may18SOB>=1)hog_menDTE=0.
If(men18DTE=0 & may18SOB=0)hog_menDTE=0.
execute.
Recode hog_menDTE (-1=sysmis).
execute.

*/////////Hogar con dualidad parcial de malnutricin////////////////*.
compute hog_duapar=-1.
If(men18DTE>=1 & may18SOB>=1)hog_duapar=1.
If(men18DTE=0 & may18SOB>=1)hog_duapar=0.
If(men18DTE>=1 & may18SOB=0)hog_duapar=0.
If(men18DTE=0 & may18SOB=0)hog_duapar=0.
execute.
Recode hog_duapar(-1=sysmis).
execute.

*/////////Hogar desnutrido////////////////*.
compute ma18dcTodos=-1.
If(may18dc=may18)ma18dcTodos=1. 
If(may18dc>may18)ma18dcTodos=0.
If(may18dc<may18)ma18dcTodos=0.
execute.
Recode ma18dcTodos (-1=sysmis).
execute.

compute hog_desn=-1.
If(me18DTETodos=1 & ma18dcTodos=1)hog_desn=1.
If(me18DTETodos=0 & ma18dcTodos=1)hog_desn=0.
If(me18DTETodos=1 & ma18dcTodos=0)hog_desn=0.
If(me18DTETodos=0 & ma18dcTodos=0)hog_desn=0.
execute.
Recode hog_desn(-1=sysmis).
execute.

*/////////Hogar obeso////////////////*.

compute me10SOBTodos=-1.
If(men10SOB=men10)me10SOBTodos=1. 
If(men10SOB>men10)me10SOBTodos=0.
If(men10SOB<men10)me10SOBTodos=0.
execute.
Recode me10SOBTodos (-1=sysmis).
execute.

compute ma10SOBTodos=-1.
execute.
If(may10SOB=may10)ma10SOBTodos=1. 
If(may10SOB>may10)ma10SOBTodos=0.
If(may10SOB<may10)ma10SOBTodos=0.
execute.
Recode ma10SOBTodos (-1=sysmis).
execute.

compute hog_obes=-1.
If(me10SOBTodos=1 & ma10SOBTodos=1)hog_obes=1.
If(me10SOBTodos=0 & ma10SOBTodos=1)hog_obes=0.
If(me10SOBTodos=1 & ma10SOBTodos=0)hog_obes=0.
If(me10SOBTodos=0 & ma10SOBTodos=0)hog_obes=0.
execute.
Recode hog_obes(-1=sysmis).
execute.

SAVE OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggHogarMiemMenMay18.sav'.

*/////////////////////////////////////////////////////////////////////////////////////////////////////////*.
MATCH FILES /FILE=*
/TABLE='DATOS1\AntroENAHOIV2007.sav'
/BY CONGLOME VIVIENDA HOGAR
/keep
CONGLOME VIVIENDA HOGAR CODPERSO 
UBIGEO ALTITUD FACTCENAN
NVISITA
FecEnc
UBIGEO AREA DOMINIO ESTRATO ccdd 
nro_mie mef nino
men10 may10 men10SOB may10SOB
men18 may18 men18DTE may18dc may18SOB
me18DTETodos ma18SOBTodos ma18dcTodos me10SOBTodos ma10SOBTodos
anem_nin anem_mef
hog_doble hog_sinmal
hog_duaglobal
hog_adSOB
hog_menDTE
hog_duapar
hog_desn
hog_obes
Ngasper POBREZA
jhNivEd1 jhIdiom1 jhEdad1 jhSexo.
execute.
MATCH FILES /TABLE=*
 /FILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AntroENAHOIV2007.sav'
 /RENAME (anem_mef anem_nin filter_$ flagPeso flagTalla jhEdad jhIdiom jhNivEd linea07 linpe07 may10 may10SOB may18 may18dc
  may18SOB mef men10 men10SOB men18 men18DTE nino nro_mie P301A pC104 pC104_median pC104_median_1 pC107 pC107_median
  pC107_median_1 PrimaryLast2 source01 UBIGEO = d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21
  d22 d23 d24 d25 d26 d27 d28 d29 d30 d31)
 /BY CONGLOME VIVIENDA HOGAR
 /DROP= d0 d1 d2 d3 d4 d5 d6 d7 d8 d9 d10 d11 d12 d13 d14 d15 d16 d17 d18 d19 d20 d21 d22 d23 d24 d25 d26 d27 d28 d29 d30
  d31.
EXECUTE.


AGGREGATE
  /OUTFILE='C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\AggHogarMiemMenMay18_1.sav'
  /BREAK=CONGLOME VIVIENDA HOGAR UBIGEO
  /nro_mie_mean = MEAN(nro_mie) /mef_mean = MEAN(mef) /nino_mean = MEAN(nino) /men18_mean = MEAN(men18) /may18_mean =
  MEAN(may18) /men18DTE_mean = MEAN(men18DTE) /men10_mean = MEAN(men10) /men10SOB_mean = MEAN(men10SOB) /may10_mean =
  MEAN(may10) /may10SOB_mean = MEAN(may10SOB) /may18dc_mean = MEAN(may18dc) /may18SOB_mean = MEAN(may18SOB) /anem_nin_mean =
  MEAN(anem_nin) /anem_mef_mean = MEAN(anem_mef) /hog_doble_mean = MEAN(hog_doble) /hog_sinmal_mean = MEAN(hog_sinmal)
 /me18DTETodos_mean = MEAN(me18DTETodos) /ma18SOBTodos_mean = MEAN(ma18SOBTodos) /hog_duaglobal_mean = MEAN(hog_duaglobal)
 /hog_adSOB_mean = MEAN(hog_adSOB) /hog_menDTE_mean = MEAN(hog_menDTE) /hog_duapar_mean = MEAN(hog_duapar) /ma18dcTodos_mean =
  MEAN(ma18dcTodos) /hog_desn_mean = MEAN(hog_desn) /me10SOBTodos_mean = MEAN(me10SOBTodos) /ma10SOBTodos_mean =
  MEAN(ma10SOBTodos) /hog_obes_mean = MEAN(hog_obes).

string ccdd (a2).
compute ccdd=substr(ubigeo,1,2).
execute.

*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.
*		TABULADOS: CAPITULO VII: CARACTERIZACIN DEL PERFIL NUTRICIONAL DE  LOS HOGARES	*.				          *.
*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*.

*/////Hogar sin malnutricion////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = ESTRATO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = Ngasper  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = POBREZA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_sinmal
 /SUBPOP TABLE = jhsexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar con dualidad global de malnutricion////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duaglobal
 /SUBPOP TABLE = AREA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.


*/////Hogar con adultos con sobrepeso////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = ESTRATO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = Ngasper  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = POBREZA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_adSOB 
 /SUBPOP TABLE = jhsexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar con adultos con menores c/DTE////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE 
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = ESTRATO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = Ngasper  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = POBREZA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_menDTE  
 /SUBPOP TABLE = jhsexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.

*/////Hogar con dualidad parcial de malnutricion////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar 
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar  
 /SUBPOP TABLE = DOMINIO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar  
 /SUBPOP TABLE = ESTRATO  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar 
 /SUBPOP TABLE = Ngasper  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar  
 /SUBPOP TABLE = POBREZA  DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar  
 /SUBPOP TABLE = jhNivEd1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar 
 /SUBPOP TABLE = jhIdiom1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar 
 /SUBPOP TABLE = jhEdad1 DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_duapar  
 /SUBPOP TABLE = jhsexo DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
*/////Hogar obeso////*.
* Complex Samples Frequencies.
CSTABULATE
 /PLAN FILE = 'C:\06 CENAN\04 UINutricional\08 ENAHO\04 BDatosAnaliticasENAHO\enaho2007Hogar.csaplan'
 /TABLES VARIABLES = hog_obes
 /SUBPOP TABLE = AREA DISPLAY=LAYERED
 /CELLS  TABLEPCT
 /STATISTICS  SE CIN(95) COUNT
 /MISSING SCOPE = TABLE CLASSMISSING = EXCLUDE.
