﻿CREATE TABLE "tb_etnia" (
"id_etnia" int4 NOT NULL,
"descripcion" varchar(255) COLLATE "default" NOT NULL,
CONSTRAINT "tb_etnia_pkey" PRIMARY KEY ("id_etnia") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_etnia" IS 'Esta tabla contiene una lista de grupos étnicos y su descripción.';
COMMENT ON COLUMN "tb_etnia"."id_etnia" IS 'código de etnia';
COMMENT ON COLUMN "tb_etnia"."descripcion" IS 'Grupo étnico';

CREATE TABLE "tb_persona" (
"id_persona" int4 NOT NULL,
"anio_nacimiento" int4,
"pais_nacimiento" char(3),
"sexo" char(1),
"id_ubigeo_domicilio" int4,
"Id_etnia" int4,
CONSTRAINT "tb_persona_pkey" PRIMARY KEY ("id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_persona" IS 'Esta tabla contiene una lista de personas, año de nacimiento, país de nacimiento, sexo, ib_ubigeo_domicilio (al ubigeo de domicilio), grupo étnico, fecha de fallecimiento (si no ha fallecido es NULL). ';
COMMENT ON COLUMN "tb_persona"."id_persona" IS 'identificador';
COMMENT ON COLUMN "tb_persona"."anio_nacimiento" IS 'año de nacimiento';
COMMENT ON COLUMN "tb_persona"."pais_nacimiento" IS 'País ISO3';
COMMENT ON COLUMN "tb_persona"."sexo" IS 'M: Masculino, F: Femenino';
COMMENT ON COLUMN "tb_persona"."id_ubigeo_domicilio" IS 'Identificador a la tabla de Ubigeo de Domicilio';
COMMENT ON COLUMN "tb_persona"."Id_etnia" IS 'Identificador de la tabla de Etnia';

CREATE TABLE "tb_grupo_riesgo" (
"id_grupo_riesgo" int4 NOT NULL,
"descripcion" varchar(255),
PRIMARY KEY ("id_grupo_riesgo") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_grupo_riesgo" IS 'Esta tabla contiene una lista de grupos de riesgo de enfermedades priorizados para las intervenciones estratégicas de vacunación.';
COMMENT ON COLUMN "tb_grupo_riesgo"."id_grupo_riesgo" IS 'código de riesgo de riesgo';
COMMENT ON COLUMN "tb_grupo_riesgo"."descripcion" IS 'Descripción del grupo de riesgo';

CREATE TABLE "tb_ubigeo" (
"id_ubigeo" int4 NOT NULL,
"ubigeo_reniec" char(6),
"ubigeo_inei" char(128),
"departamento_inei" varchar(12),
"departamento" varchar(255),
"provincia_inei" varchar(255),
"provincia" varchar(255),
"distrito" varchar(255),
"region" varchar(255),
"macroregion_inei" varchar(255),
"macroregion_minsa" varchar(255),
"iso_3166_2" char(4),
"fips" char(4),
"superficie" float4,
"altitud" float4,
"latitud" decimal(14),
"longitud" decimal(14),
PRIMARY KEY ("id_ubigeo") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_ubigeo" IS 'Esta tabla contiene la lista de los 1874 distritos del Perú con la descripción de los departamentos, provincias, distritos, región, macroregión, superficie y coordenadas geográficas de su capital. ';
COMMENT ON COLUMN "tb_ubigeo"."id_ubigeo" IS 'secuencial';
COMMENT ON COLUMN "tb_ubigeo"."ubigeo_reniec" IS 'UBIGEO distrital de RENIEC';
COMMENT ON COLUMN "tb_ubigeo"."ubigeo_inei" IS 'UBIGEO distrital de INEI';
COMMENT ON COLUMN "tb_ubigeo"."departamento_inei" IS 'UBIGEO departamental de INEI';
COMMENT ON COLUMN "tb_ubigeo"."departamento" IS 'Nombre del Departamento';
COMMENT ON COLUMN "tb_ubigeo"."provincia_inei" IS 'UBIGEO provincial de INEI';
COMMENT ON COLUMN "tb_ubigeo"."provincia" IS 'Nombre de la Provincia';
COMMENT ON COLUMN "tb_ubigeo"."distrito" IS 'Nombre del Distrito';
COMMENT ON COLUMN "tb_ubigeo"."region" IS 'Nombre de la Región';
COMMENT ON COLUMN "tb_ubigeo"."macroregion_inei" IS 'Macroregión a la que pertenece la región, según INEI';
COMMENT ON COLUMN "tb_ubigeo"."macroregion_minsa" IS 'Macroregión a la que pertene la región, según el MINSA';
COMMENT ON COLUMN "tb_ubigeo"."iso_3166_2" IS 'Código ISO-3166-2 para la Región';
COMMENT ON COLUMN "tb_ubigeo"."fips" IS 'Código FIPS para la Región';
COMMENT ON COLUMN "tb_ubigeo"."superficie" IS 'Superficie en Km2 del Distrito';
COMMENT ON COLUMN "tb_ubigeo"."altitud" IS 'Altitud del Distrito en metros sobre el nivel del mar (msnm)';
COMMENT ON COLUMN "tb_ubigeo"."latitud" IS 'Latitud del Distrito';
COMMENT ON COLUMN "tb_ubigeo"."longitud" IS 'Longitud del Distrito';

CREATE TABLE "tb_eess" (
"id_eess" int4 NOT NULL,
"codigo_reanes" varchar(10),
"categoria" varchar(25),
"nombre" varchar(255),
"diresa" varchar(255),
"red" varchar(255),
"direccion" varchar(255),
"longitud" decimal(14),
"latitud" decimal(14),
"id_ubigeo" int4,
PRIMARY KEY ("id_eess") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_eess" IS 'Esta tabla contiene la lista de los 23,656 establecimientos de salud del Perú del Registro Nacional de Instituciones Prestadoras de Servicios de Salud RENIPRESS de la Superintendencia Nacional de Salud – SUSALUD.';
COMMENT ON COLUMN "tb_eess"."id_eess" IS 'consecutivo';
COMMENT ON COLUMN "tb_eess"."codigo_reanes" IS 'codigo de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."categoria" IS 'categoría de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."nombre" IS 'nombre de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."diresa" IS 'diresa de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."red" IS 'red de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."direccion" IS 'dirección de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."longitud" IS 'longitud de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."latitud" IS 'latitud de establecimiento de salud';
COMMENT ON COLUMN "tb_eess"."id_ubigeo" IS 'id de establecimiento de salud';

CREATE TABLE "tb_vacunados_covid19" (
"id_vacunados_covid19" int4 NOT NULL,
"id_persona_vacunada" int4,
"fecha_vacunacion" date,
"id_eess" int4,
"id_centro_vacunacion" int4,
"id_vacuna" int4,
"id_grupo_riesgo" int4,
"dosis" int4,
PRIMARY KEY ("id_vacunados_covid19") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_vacunados_covid19" IS 'Esta tabla contiene la lista de las personas vacunadas, según fecha, lugar, grupo de riesgo y dosis aplicadas contra la Covid19.';
COMMENT ON COLUMN "tb_vacunados_covid19"."id_vacunados_covid19" IS 'consecutivo';
COMMENT ON COLUMN "tb_vacunados_covid19"."id_persona_vacunada" IS 'codigo correlativo del vacunado';
COMMENT ON COLUMN "tb_vacunados_covid19"."fecha_vacunacion" IS 'Fecha de vacunación';
COMMENT ON COLUMN "tb_vacunados_covid19"."id_centro_vacunacion" IS 'Centro de vacunación';
COMMENT ON COLUMN "tb_vacunados_covid19"."id_vacuna" IS 'codigo correlativo de la vacuna aplicada';
COMMENT ON COLUMN "tb_vacunados_covid19"."dosis" IS 'Dosis aplicadas';

CREATE TABLE "tb_vacuna" (
"id_vacuna" int4 NOT NULL,
"fabricante" varchar(200),
"pais" char(3),
PRIMARY KEY ("id_vacuna") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_vacuna" IS 'Esta tabla contiene la lista de las características de las vacunas aplicadas según fabricante y país de origen.';
COMMENT ON COLUMN "tb_vacuna"."id_vacuna" IS 'codigo correlativo de la vacuna aplicada';
COMMENT ON COLUMN "tb_vacuna"."fabricante" IS 'Fabricante de la vacuna (marca)';
COMMENT ON COLUMN "tb_vacuna"."pais" IS 'pais de origen';

CREATE TABLE "tb_centro_vacunacion" (
"id_centro_vacunacion" int4 NOT NULL,
"id_ubigeo" int4 NOT NULL,
"nombre" varchar(200),
"codigo_centro_vacunacion" varchar(10),
"entidad_administra" varchar(200),
"longitud" decimal(14),
"latitud" decimal(14),
"direccion" varchar(200),
PRIMARY KEY ("id_centro_vacunacion") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_centro_vacunacion" IS 'Esta tabla contiene la lista de los centros de vacunación programadas según entidad y ubicación geográfica a nivel nacional del territorio peruano.';
COMMENT ON COLUMN "tb_centro_vacunacion"."id_centro_vacunacion" IS 'secuencial';
COMMENT ON COLUMN "tb_centro_vacunacion"."id_ubigeo" IS 'secuencial';
COMMENT ON COLUMN "tb_centro_vacunacion"."nombre" IS 'Centro de vacunación';
COMMENT ON COLUMN "tb_centro_vacunacion"."codigo_centro_vacunacion" IS 'codigo de centro de vacunacion';
COMMENT ON COLUMN "tb_centro_vacunacion"."entidad_administra" IS 'entidad administrativa';
COMMENT ON COLUMN "tb_centro_vacunacion"."longitud" IS 'longitud del centro de vacunacion';
COMMENT ON COLUMN "tb_centro_vacunacion"."latitud" IS 'latitud del centro de vacunacion';
COMMENT ON COLUMN "tb_centro_vacunacion"."direccion" IS 'Dirección del centro de vacunación';

CREATE TABLE "tb_programacion" (
"id_programacion" int4 NOT NULL,
"id_centro_vacunacion" int4 NOT NULL,
"fecha_programa" date,
"edad_rango_inicial" int4,
"edad_rango_final" int4,
"id_vacuna" int4,
PRIMARY KEY ("id_programacion") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_programacion" IS 'Esta tabla contiene la programación de la aplicación de las vacunas según centro de vacunación, fecha y edad rango de inicio y edad rango final de vacunación';
COMMENT ON COLUMN "tb_programacion"."id_programacion" IS 'correlativo';
COMMENT ON COLUMN "tb_programacion"."id_centro_vacunacion" IS 'correlativo';
COMMENT ON COLUMN "tb_programacion"."fecha_programa" IS 'Fecha de programación de vacuna';
COMMENT ON COLUMN "tb_programacion"."edad_rango_inicial" IS 'Edad_Rango de inicialización de vacuna';
COMMENT ON COLUMN "tb_programacion"."edad_rango_final" IS 'Edad_Rango de finalización de vacuna';
COMMENT ON COLUMN "tb_programacion"."id_vacuna" IS 'Id de vacunación de vacuna';

CREATE TABLE "tb_morbi_edas" (
"id_morbilidad" int4 NOT NULL,
"id_persona" int4,
"fecha_atencion" date,
"diagnostico_ciex" varchar(4),
"edad" int4,
"tipo_edad" varchar(3),
PRIMARY KEY ("id_morbilidad") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_morbi_edas" IS 'Esta tabla contiene las principales causas de morbilidad por enfermedades infecciosas intestinales según CIE10 (A00-A09) según edad, sexo, tipo de edad y fecha de atención, registradas en los establecimientos de salud a nivel nacional.';
COMMENT ON COLUMN "tb_morbi_edas"."id_morbilidad" IS 'secuecial';
COMMENT ON COLUMN "tb_morbi_edas"."id_persona" IS 'identificador';
COMMENT ON COLUMN "tb_morbi_edas"."fecha_atencion" IS 'Fecha de atención';
COMMENT ON COLUMN "tb_morbi_edas"."diagnostico_ciex" IS 'Codigo CIEX';
COMMENT ON COLUMN "tb_morbi_edas"."edad" IS 'Edad del paciente';
COMMENT ON COLUMN "tb_morbi_edas"."tipo_edad" IS 'Tipo de edad: AÑO, MES, DIA, HOR, MIN, SEG, SEM';

CREATE TABLE "tb_morbi_iras" (
"id_morbilidad" int4 NOT NULL,
"id_persona" int4,
"fecha_atencion" date,
"diagnostico_ciex" varchar(4),
"edad" int4,
"tipo_edad" varchar(3),
PRIMARY KEY ("id_morbilidad") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_morbi_iras" IS 'Esta tabla contiene las principales causas de morbilidad por enfermedades infecciosas intestinales según CIE10 (J00-J06) según edad, sexo, tipo de edad y fecha de atención, registradas en los establecimientos de salud a nivel nacional.';
COMMENT ON COLUMN "tb_morbi_iras"."id_morbilidad" IS 'secuecial';
COMMENT ON COLUMN "tb_morbi_iras"."id_persona" IS 'identificador';
COMMENT ON COLUMN "tb_morbi_iras"."fecha_atencion" IS 'Fecha de atención';
COMMENT ON COLUMN "tb_morbi_iras"."diagnostico_ciex" IS 'Codigo CIEX';
COMMENT ON COLUMN "tb_morbi_iras"."edad" IS 'Edad del paciente';
COMMENT ON COLUMN "tb_morbi_iras"."tipo_edad" IS 'Tipo de edad: AÑO, MES, DIA, HOR, MIN, SEG, SEM';

CREATE TABLE "tb_anemia" (
"id_morbilidad" int4 NOT NULL,
"id_persona" int4,
"fecha_atencion" date,
"diagnostico_ciex" varchar(4),
"edad" int4,
"tipo_edad" varchar(3),
PRIMARY KEY ("id_morbilidad") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_anemia" IS 'Esta tabla contiene las principales causas de morbilidad por anemia según CIE10 (D50-D53, D64) según edad, sexo, tipo de edad y fecha de atención, registradas en los establecimientos de salud a nivel nacional.';
COMMENT ON COLUMN "tb_anemia"."id_morbilidad" IS 'secuecial';
COMMENT ON COLUMN "tb_anemia"."id_persona" IS 'identificador';
COMMENT ON COLUMN "tb_anemia"."fecha_atencion" IS 'Fecha de atención';
COMMENT ON COLUMN "tb_anemia"."diagnostico_ciex" IS 'Codigo CIEX';
COMMENT ON COLUMN "tb_anemia"."edad" IS 'Edad del paciente';
COMMENT ON COLUMN "tb_anemia"."tipo_edad" IS 'Tipo de edad: AÑO, MES, DIA, HOR, MIN, SEG, SEM';

CREATE TABLE "tb_eess_covid19" (
"id_eess" int4 NOT NULL,
"id_ubigeo" int4,
"codigo_reanes" varchar(5),
"atiende_covid19" int4,
"camas_ucin_av" int4,
"total_camas_ucin" int4,
"camas_hospitalizacion_con_oxigeno_av" int4,
"camas_hospitalizacion_sin_oxigeno_av" int4,
"camas_uci_con_ventilador_mecanico_av" int4,
"camas_uci_sin_ventilador_mecanico_av" int4,
"total_camas_hospitalizacion_con_oxigeno" int4,
"total_camas_hospitalizacion_sin_oxigeno" int4,
"total_camas_uci_con_ventilador_mecanico" int4,
"total_camas_uci_sin_ventilador_mecanico" int4,
"camas_hospitalizacion_av" int4,
"camas_hospitalizacion_con_oxigeno_usadas_av" int4,
"camas_hospitalizacion_sin_oxigeno_usadas_av" int4,
"total_camas_hospitalizacion" int4,
"camas_uci_con_ventilador_mecanico_usadas_av" int4,
"camas_uci_sin_ventilador_mecanico_usadas_av" int4,
"camas_ucin_con_oxigeno_usadas_av" int4,
"camas_ucin_sin_oxigeno_usadas_av" int4,
PRIMARY KEY ("id_eess") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_eess_covid19" IS 'Esta tabla contiene la situación de la disponibilidad de hospitalización y UCI a nivel nacional y de todos los subsistemas para las atenciones Covid19';
COMMENT ON COLUMN "tb_eess_covid19"."id_eess" IS 'consecutivo';
COMMENT ON COLUMN "tb_eess_covid19"."codigo_reanes" IS 'codigo de establecimiento de salud';
COMMENT ON COLUMN "tb_eess_covid19"."atiende_covid19" IS 'atencion covid19';
COMMENT ON COLUMN "tb_eess_covid19"."camas_ucin_av" IS 'Cama UCIN ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."total_camas_ucin" IS 'Total de camas disponibles en UCIN';
COMMENT ON COLUMN "tb_eess_covid19"."camas_hospitalizacion_con_oxigeno_av" IS 'Camas de hospitalizacion con Oxigeno ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_hospitalizacion_sin_oxigeno_av" IS 'Camas de hospitalizacion sin Oxigeno ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_uci_con_ventilador_mecanico_av" IS 'Camas de uci con ventilador Mecanico ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_uci_sin_ventilador_mecanico_av" IS 'Camas de uci sin ventilador Mecanico ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."total_camas_hospitalizacion_con_oxigeno" IS 'Total de camas hospitalizacion Con ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."total_camas_hospitalizacion_sin_oxigeno" IS 'Total de camas hospitalizacion Sin oxigeno';
COMMENT ON COLUMN "tb_eess_covid19"."total_camas_uci_con_ventilador_mecanico" IS 'Total de camas uci con Ventilador';
COMMENT ON COLUMN "tb_eess_covid19"."total_camas_uci_sin_ventilador_mecanico" IS 'Total de camas uci sin Ventilador';
COMMENT ON COLUMN "tb_eess_covid19"."camas_hospitalizacion_av" IS 'Camas de hospitalizacion';
COMMENT ON COLUMN "tb_eess_covid19"."camas_hospitalizacion_con_oxigeno_usadas_av" IS 'Camas de hospitalizacion con oxigeno Usadas ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_hospitalizacion_sin_oxigeno_usadas_av" IS 'Camas de hospitalizacion sin oxigeno Usadas ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."total_camas_hospitalizacion" IS 'Total de Camas de hospitalización';
COMMENT ON COLUMN "tb_eess_covid19"."camas_uci_con_ventilador_mecanico_usadas_av" IS 'Camas de uci con ventilador mecanico Usadas ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_uci_sin_ventilador_mecanico_usadas_av" IS 'Camas de uci sin ventilador mecanico Usadas ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_ucin_con_oxigeno_usadas_av" IS 'Camas de ucin con oxigeno Usadas ocupada';
COMMENT ON COLUMN "tb_eess_covid19"."camas_ucin_sin_oxigeno_usadas_av" IS 'Camas de ucin sin oxigeno Usadas ocupada';

CREATE TABLE "tb_atepac_covid19" (
"id_eess" int4 NOT NULL,
"Id_persona" int4 NOT NULL,
"fecha_ingreso" date,
"hora_ingreso" varchar(10),
"es_recuperado" int4,
"fecha_alta" date,
"es_recuperado_voluntario" int4,
"fecha_alta_voluntaria" date,
"es_fallecido" int4,
"fecha_fallecido" date,
"es_referido" int4,
"fecha_referido" date,
"tipo_ingreso" int4,
"eess_destino_id" varchar(25),
PRIMARY KEY ("id_eess", "Id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_atepac_covid19" IS 'Esta tabla contiene la situación del paciente covid19, el estado de ingreso, evolución, fallecimiento, alta y referencia';
COMMENT ON COLUMN "tb_atepac_covid19"."id_eess" IS 'consecutivo';
COMMENT ON COLUMN "tb_atepac_covid19"."Id_persona" IS 'consecutivo';
COMMENT ON COLUMN "tb_atepac_covid19"."fecha_ingreso" IS 'Fecha de ingreso a eess';
COMMENT ON COLUMN "tb_atepac_covid19"."hora_ingreso" IS 'Hora de ingreso a eess';
COMMENT ON COLUMN "tb_atepac_covid19"."es_recuperado" IS 'Estado recuperado';
COMMENT ON COLUMN "tb_atepac_covid19"."fecha_alta" IS 'Fecha de alta';
COMMENT ON COLUMN "tb_atepac_covid19"."es_recuperado_voluntario" IS 'Estado recuperado con alta voluntaria';
COMMENT ON COLUMN "tb_atepac_covid19"."fecha_alta_voluntaria" IS 'Fecha de alta voluntaria';
COMMENT ON COLUMN "tb_atepac_covid19"."es_fallecido" IS 'Estado fallecido';
COMMENT ON COLUMN "tb_atepac_covid19"."fecha_fallecido" IS 'Fecha de fallecimiento';
COMMENT ON COLUMN "tb_atepac_covid19"."es_referido" IS 'Estado referido';
COMMENT ON COLUMN "tb_atepac_covid19"."fecha_referido" IS 'Fecha de referencia';
COMMENT ON COLUMN "tb_atepac_covid19"."tipo_ingreso" IS 'Tipo de ingreso';
COMMENT ON COLUMN "tb_atepac_covid19"."eess_destino_id" IS 'Establecimiento de destino';

CREATE TABLE "tb_seg_pac_covid19" (
"id_persona" int4 NOT NULL,
"atencion_id" int4,
"fecha_seguimiento" date,
"estado" varchar(25),
"complicaciones" varchar(25),
"descripcion_otros" varchar(25),
"observaciones" varchar(25),
"evolucion" varchar(25),
"hospitalizacion" varchar(25),
"hora_seguimiento" varchar(25),
"con_oxigeno" varchar(25),
"con_ventilacion" varchar(25),
"esta_hospitalizacion" varchar(25),
"esta_uci" varchar(25),
"esta_ucin" varchar(25),
PRIMARY KEY ("id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_seg_pac_covid19" IS 'Esta tabla contiene la caracterización del seguimiento de paciente Covid19, sus complicaciones, evolución y estado general durante la hospitalización.';
COMMENT ON COLUMN "tb_seg_pac_covid19"."id_persona" IS 'consecutivo';
COMMENT ON COLUMN "tb_seg_pac_covid19"."atencion_id" IS 'consecutivo';
COMMENT ON COLUMN "tb_seg_pac_covid19"."fecha_seguimiento" IS 'Fecha de seguimiento del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."estado" IS 'Estado del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."complicaciones" IS 'Complicaciones del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."descripcion_otros" IS 'Descripcion de otras complicaciones';
COMMENT ON COLUMN "tb_seg_pac_covid19"."observaciones" IS 'Observaciones del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."evolucion" IS 'Evolucion del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."hospitalizacion" IS 'Hospitalizado conn/sin oxigeno del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."hora_seguimiento" IS 'Hora de seguimiento del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."con_oxigeno" IS 'Con de oxigeno del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."con_ventilacion" IS 'Con de ventilacion del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."esta_hospitalizacion" IS 'Estado de hospitalizacion del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."esta_uci" IS 'Estado de uci del paciente';
COMMENT ON COLUMN "tb_seg_pac_covid19"."esta_ucin" IS 'Estado de ucin del paciente';

CREATE TABLE "tb_morbi_emergencias" (
"id_persona" int4 NOT NULL,
"edad" int4,
"tipo_edad" varchar(25),
"sexo" varchar(25),
"fecha_atencion" date,
"diagnostico" varchar(25),
"tipo_dx" varchar(25),
"id_eess" int4,
PRIMARY KEY ("id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_morbi_emergencias" IS 'Esta tabla contiene la morbilidad como causa de atención en las unidades de emergencias de los establecimientos de salud del Perú. Nota: Las atenciones de signos y síntomas no son contabilizadas como morbilidad';
COMMENT ON COLUMN "tb_morbi_emergencias"."id_persona" IS 'consecutivo';
COMMENT ON COLUMN "tb_morbi_emergencias"."edad" IS 'edad del paciente';
COMMENT ON COLUMN "tb_morbi_emergencias"."tipo_edad" IS 'tipo_edad del paciente';
COMMENT ON COLUMN "tb_morbi_emergencias"."sexo" IS 'sexo del paciente';
COMMENT ON COLUMN "tb_morbi_emergencias"."fecha_atencion" IS 'fecha_atencion del paciente';
COMMENT ON COLUMN "tb_morbi_emergencias"."diagnostico" IS 'diagnóstico del paciente CIE10';
COMMENT ON COLUMN "tb_morbi_emergencias"."tipo_dx" IS 'tipo_dx del paciente';
COMMENT ON COLUMN "tb_morbi_emergencias"."id_eess" IS 'consecutivo';

CREATE TABLE "tb_poblacion" (
"ubigeo_reniec" varchar(6),
"ubigeo_inei" varchar(6),
"region" varchar(30),
"departamento" varchar(30),
"provincia" varchar(50),
"distrito" varchar(150),
"edad_anio" varchar(5),
"sexo" varchar(4),
"cantidad" int4
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_poblacion" IS 'Esta tabla contiene el número de habitantes registradas en el Registro Nacional de Identificación y Estado Civil – RENIEC, según departamento, provincia, distrito, sexo y grupos de edad.';
COMMENT ON COLUMN "tb_poblacion"."ubigeo_reniec" IS 'Ubigeo RENIEC';
COMMENT ON COLUMN "tb_poblacion"."ubigeo_inei" IS 'Ubigeo INEI';
COMMENT ON COLUMN "tb_poblacion"."region" IS 'REGION de residencia';
COMMENT ON COLUMN "tb_poblacion"."departamento" IS 'DEPARTAMENTO de desidencia';
COMMENT ON COLUMN "tb_poblacion"."provincia" IS 'PROVINCIA de residencia';
COMMENT ON COLUMN "tb_poblacion"."distrito" IS 'DISTRITO de residencia';
COMMENT ON COLUMN "tb_poblacion"."edad_anio" IS 'Edad en años';
COMMENT ON COLUMN "tb_poblacion"."sexo" IS 'sexo';
COMMENT ON COLUMN "tb_poblacion"."cantidad" IS 'poblacion';

CREATE TABLE "tb_pruebas_nomoleculares" (
"id_persona" int4 NOT NULL,
"fecha_prueba" date,
"id_tipo_prueba" int4,
"id_resultado_prueba" int4,
"id_ubigeo_prueba " int4,
PRIMARY KEY ("id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_pruebas_nomoleculares" IS 'pruebas nomoleculares';
COMMENT ON COLUMN "tb_pruebas_nomoleculares"."id_persona" IS 'consecutivo ';
COMMENT ON COLUMN "tb_pruebas_nomoleculares"."fecha_prueba" IS 'Fecha de realizacion de la prueba (El mismo día entregan resultado)';
COMMENT ON COLUMN "tb_pruebas_nomoleculares"."id_tipo_prueba" IS 'Tipo de prueba realizada (Rápida, Antígena, Quimioluminiscencia)';
COMMENT ON COLUMN "tb_pruebas_nomoleculares"."id_resultado_prueba" IS 'Resultado de las pruebas realizadas';
COMMENT ON COLUMN "tb_pruebas_nomoleculares"."id_ubigeo_prueba " IS 'Ubigeo donde se realizó la prueba';

CREATE TABLE "tb_seguimiento_clinico_f300" (
"id_persona" int4 NOT NULL,
"fecha_Seguimiento" date,
"tipo_Seguimiento" varchar(30),
"id_tipo_Estado_seg" int4,
PRIMARY KEY ("id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_seguimiento_clinico_f300" IS 'seguimiento clinico';
COMMENT ON COLUMN "tb_seguimiento_clinico_f300"."id_persona" IS 'consecutivo';
COMMENT ON COLUMN "tb_seguimiento_clinico_f300"."fecha_Seguimiento" IS 'Fecha de seguimiento clínico realizado a la persona';
COMMENT ON COLUMN "tb_seguimiento_clinico_f300"."tipo_Seguimiento" IS 'Tipo de seguimiento realizado (Telefónico o  Presencial)';
COMMENT ON COLUMN "tb_seguimiento_clinico_f300"."id_tipo_Estado_seg" IS 'Estado clínico de la persona en la fecha de seguimiento';

CREATE TABLE "tb_sospechosos_f00_covid" (
"id_persona" int4 NOT NULL,
"fecha_Contacto" date,
"Flag_sospechoso" int4,
"fecha_sintomas" date,
"tos" int4,
"cefalea" int4,
"congestion_nasal" int4,
"dificultad_respiratoria" int4,
"dolor_garganta" int4,
"fiebre" int4,
"diarrea" int4,
"nauseas" int4,
"anosmia_hiposmia" int4,
"dolor_abdominal" int4,
"dolor_articulaciones" int4,
"dolor_muscular" int4,
"dolor_pecho" int4,
"otros_sintomas" int4,
"id_ubigeo_f00" int4,
PRIMARY KEY ("id_persona") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_sospechosos_f00_covid" IS 'sospechoso f00 covid';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."id_persona" IS 'consecutivo ';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."fecha_Contacto" IS 'Fecha de contacto de la persona a traves del 113';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."Flag_sospechoso" IS 'Flag: 1 (Sospechoso covid), 0 (No Sospechoso covid)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."fecha_sintomas" IS 'Fecha de inicio de sintomas';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."tos" IS 'Flag: 1 (Persona con sintoma tos), 0 (Persona sin sintoma tos)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."cefalea" IS 'Flag: 1 (Persona con sintoma cefalea), 0 (Persona sin sintoma cefalea)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."congestion_nasal" IS 'Flag: 1 (Persona con sintoma congestion nasal), 0 (Persona sin sintoma congestion nasal)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."dificultad_respiratoria" IS 'Flag: 1 (Persona con sintoma dificultad respiratoria), 0 (Persona sin sintoma dificultad respiratoria)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."dolor_garganta" IS 'Flag: 1 (Persona con sintoma dolor garganta), 0 (Persona sin sintoma dolor garganta)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."fiebre" IS 'Flag: 1 (Persona con sintoma fiebre), 0 (Persona sin sintoma fiebre)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."diarrea" IS 'Flag: 1 (Persona con sintoma diarrea), 0 (Persona sin sintoma diarrea)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."nauseas" IS 'Flag: 1 (Persona con sintoma nauseas), 0 (Persona sin sintoma nauseas)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."anosmia_hiposmia" IS 'Flag: 1 (Persona con sintoma anosmia hiposmia), 0 (Persona sin sintoma anosmia hiposmia)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."dolor_abdominal" IS 'Flag: 1 (Persona con sintoma dolor abdominal), 0 (Persona sin sintoma dolor abdominal)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."dolor_articulaciones" IS 'Flag: 1 (Persona con sintoma dolor articulaciones), 0 (Persona sin sintoma dolor articulaciones)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."dolor_muscular" IS 'Flag: 1 (Persona con sintoma dolor muscular), 0 (Persona sin sintoma dolor muscular)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."dolor_pecho" IS 'Flag: 1 (Persona con sintoma dolor pecho), 0 (Persona sin sintoma dolor pecho)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."otros_sintomas" IS 'Flag: 1 (Persona con otros sintomas), 0 (Persona sin otros sintomas)';
COMMENT ON COLUMN "tb_sospechosos_f00_covid"."id_ubigeo_f00" IS 'consecutivo';

CREATE TABLE "tb_tipo_estado_seg_covid" (
"id_tipo_Estado_seg" int4 NOT NULL,
"estado_seguimiento_clinico" varchar(100),
PRIMARY KEY ("id_tipo_Estado_seg") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_tipo_estado_seg_covid" IS 'tipo de estado';
COMMENT ON COLUMN "tb_tipo_estado_seg_covid"."id_tipo_Estado_seg" IS 'correlativo';
COMMENT ON COLUMN "tb_tipo_estado_seg_covid"."estado_seguimiento_clinico" IS 'estado de seguimiento clinico';

CREATE TABLE "tb_resultado_prueba_covid" (
"id_resultado_prueba" int4 NOT NULL,
"resultado_prueba" varchar(100),
PRIMARY KEY ("id_resultado_prueba") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_resultado_prueba_covid" IS 'resultado de prueba covid';
COMMENT ON COLUMN "tb_resultado_prueba_covid"."id_resultado_prueba" IS 'correlativo';
COMMENT ON COLUMN "tb_resultado_prueba_covid"."resultado_prueba" IS 'resultado de la prueba';

CREATE TABLE "tb_tipo_prueba_covid" (
"id_tipo_prueba" int4 NOT NULL,
"tipo_prueba" varchar(100),
PRIMARY KEY ("id_tipo_prueba") 
)
WITHOUT OIDS;
COMMENT ON TABLE "tb_tipo_prueba_covid" IS 'tipo de prueba covid';
COMMENT ON COLUMN "tb_tipo_prueba_covid"."id_tipo_prueba" IS 'correlativo';
COMMENT ON COLUMN "tb_tipo_prueba_covid"."tipo_prueba" IS 'tipo de prueba';
